/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.gen.feature;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.werewolves.core.ModWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class JacarandaTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<JacarandaTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> JacarandaTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, JacarandaTrunkPlacer::new));

    public JacarandaTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModWorld.JACARANDA_TRUNK.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(@NotNull LevelSimulatedReader pLevel, @NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, int pFreeTreeHeight, @NotNull BlockPos pPos, @NotNull TreeConfiguration pConfig) {
        int currentLogHeight;
        JacarandaTrunkPlacer.setDirtAt((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.below(), (TreeConfiguration)pConfig);
        ArrayList<FoliagePlacer.FoliageAttachment> attachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (currentLogHeight = 0; currentLogHeight < pFreeTreeHeight / 3 * 2; ++currentLogHeight) {
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(currentLogHeight), pConfig);
        }
        attachments.add(new FoliagePlacer.FoliageAttachment(pPos.above(currentLogHeight - 1).above(), 0, false));
        this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(currentLogHeight).north().east(), pConfig);
        this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(currentLogHeight + 1).north().east(2), pConfig);
        attachments.add(new FoliagePlacer.FoliageAttachment(pPos.above(currentLogHeight + 1).north().east(2).above(), 0, false));
        this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(currentLogHeight).north(), pConfig);
        this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(currentLogHeight + 1).north(2), pConfig);
        attachments.add(new FoliagePlacer.FoliageAttachment(pPos.above(currentLogHeight + 1).north(2).above(), 0, false));
        this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(currentLogHeight).south().east(), pConfig);
        this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(currentLogHeight + 1).south(2).east(), pConfig);
        attachments.add(new FoliagePlacer.FoliageAttachment(pPos.above(currentLogHeight + 1).south(2).east().above(), 0, false));
        return attachments;
    }
}

