/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.effects.WerewolvesEffect;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WerewolfWeakeningEffect
extends WerewolvesEffect {
    private final List<Modifier> modifiers;

    protected WerewolfWeakeningEffect(int color, List<Modifier> attributes) {
        super(MobEffectCategory.HARMFUL, color);
        this.modifiers = attributes;
    }

    public boolean applyEffectTick(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        return Helper.isWerewolf((Entity)entityLivingBaseIn);
    }

    public void onEffectStarted(@NotNull LivingEntity entity, int amplifier) {
        this.addAttributeModifiers(entity, entity.getAttributes(), amplifier);
    }

    public void addAttributeModifiers(@NotNull AttributeMap attributeMap, int amplifier) {
    }

    public void addAttributeModifiers(LivingEntity livingEntity, @NotNull AttributeMap attributeMap, int pAmplifier) {
        for (Map.Entry<Holder<Attribute>, AttributeTemplate> entry : this.getAttributeModifiers(livingEntity).entrySet()) {
            AttributeInstance attributeinstance = attributeMap.getInstance(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.removeModifier(entry.getValue().modifierId());
            attributeinstance.addPermanentModifier(entry.getValue().create(pAmplifier));
        }
    }

    public void removeAttributeModifiers(@NotNull AttributeMap attributeMap) {
        for (Map.Entry<Holder<Attribute>, ResourceLocation> entry : this.getAttributes().entrySet()) {
            AttributeInstance attributeinstance = attributeMap.getInstance(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.removeModifier(entry.getValue());
        }
    }

    public Map<Holder<Attribute>, ResourceLocation> getAttributes() {
        HashMap<Holder<Attribute>, ResourceLocation> map = new HashMap<Holder<Attribute>, ResourceLocation>();
        this.modifiers.forEach(modifier -> map.put(modifier.attribute(), modifier.id()));
        return map;
    }

    @NotNull
    public Map<Holder<Attribute>, AttributeTemplate> getAttributeModifiers(@Nullable LivingEntity entity) {
        HashMap<Holder<Attribute>, AttributeTemplate> map = new HashMap<Holder<Attribute>, AttributeTemplate>();
        if (entity == null || Helper.isWerewolf((Entity)entity)) {
            IWerewolf werewolf;
            int maxLevel;
            int level;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                WerewolfPlayer werewolf2 = WerewolfPlayer.get(player);
                level = werewolf2.getLevel();
                maxLevel = werewolf2.getMaxLevel();
            } else if (entity instanceof IWerewolf && (werewolf = (IWerewolf)entity) instanceof IAdjustableLevel) {
                IAdjustableLevel levelEntity = (IAdjustableLevel)werewolf;
                level = levelEntity.getEntityLevel();
                maxLevel = levelEntity.getMaxEntityLevel();
            } else {
                level = 1;
                maxLevel = 1;
            }
            this.modifiers.forEach(modifier -> map.put(modifier.attribute, modifier.createModifier(level, maxLevel)));
        }
        return map;
    }

    public static interface AttributeTemplate {
        public ResourceLocation modifierId();

        public AttributeModifier create(int var1);
    }

    protected record Modifier(Holder<Attribute> attribute, ResourceLocation id, float maxModifier, int startingAmplifier) {
        Modifier(Holder<Attribute> attribute, ResourceLocation id, float maxModifier) {
            this(attribute, id, maxModifier, 0);
        }

        public AttributeTemplate createModifier(int level, int maxLevel) {
            final double value = LevelAttributeModifier.calculateModifierValue((int)level, (int)maxLevel, (double)this.maxModifier, (double)1.3);
            return new AttributeTemplate(){

                @Override
                @NotNull
                public ResourceLocation modifierId() {
                    return this.id();
                }

                @Override
                @NotNull
                public AttributeModifier create(int pAmplifier) {
                    ++pAmplifier;
                    pAmplifier = Math.max(0, pAmplifier - startingAmplifier);
                    return new AttributeModifier(this.id(), (double)(-pAmplifier) * value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
                }
            };
        }
    }
}

