/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model.armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.client.model.armor.VampirismArmorModel;
import de.teamlapen.werewolves.client.core.ModModelRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class WolfHeadModel
extends VampirismArmorModel {
    private static final String HEAD = "head";
    private static final String RIGHT_EAR = "rightEar";
    private static final String RIGHT_EAR2 = "rightEar2";
    private static final String LEFT_EAR = "leftEar";
    private static final String LEFT_EAR2 = "leftEar2";
    private static final String NOSE = "nose";
    private static WolfHeadModel instance;
    private final ModelPart head;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild(HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rightEar = head.addOrReplaceChild(RIGHT_EAR, CubeListBuilder.create().texOffs(0, 25).addBox(-1.5f, -2.0f, -0.5f, 3.0f, 2.0f, 0.001f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-8.0f, (float)0.0f));
        PartDefinition rightEar2 = rightEar.addOrReplaceChild(RIGHT_EAR2, CubeListBuilder.create().texOffs(6, 23).addBox(-1.5f, -0.001f, -2.0f, 3.0f, 0.001f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-0.5f));
        PartDefinition leftEar = head.addOrReplaceChild(LEFT_EAR, CubeListBuilder.create().texOffs(0, 23).addBox(-1.5f, -2.0f, -0.5f, 3.0f, 2.0f, 0.001f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-8.0f, (float)0.0f));
        PartDefinition leftEar2 = leftEar.addOrReplaceChild(LEFT_EAR2, CubeListBuilder.create().texOffs(6, 25).addBox(-1.5f, -0.001f, -2.0f, 3.0f, 0.001f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-0.5f));
        PartDefinition nose = head.addOrReplaceChild(NOSE, CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static WolfHeadModel getInstance(HumanoidModel<?> wearerModel) {
        if (instance == null) {
            instance = new WolfHeadModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModModelRender.WOLF_HEAD));
        }
        instance.copyFromHumanoid(wearerModel);
        return instance;
    }

    public WolfHeadModel(ModelPart root) {
        this.head = root.getChild(HEAD);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int pPackedLight, int pPackedOverlay, int color) {
        poseStack.pushPose();
        poseStack.scale(1.2f, 1.2f, 1.2f);
        this.head.render(poseStack, buffer, pPackedLight, pPackedOverlay, color);
        poseStack.popPose();
    }

    @NotNull
    protected Iterable<ModelPart> getHeadModels() {
        return ImmutableList.of((Object)this.head);
    }
}

