/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.client.model.WerewolfBeastModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class Werewolf4LModel<T extends LivingEntity>
extends WerewolfBaseModel<T> {
    private static final String BODY = "body";
    private static final String HIP = "hip";
    private static final String NECK = "neck";
    private static final String ARM_LEFT = "armLeft";
    private static final String ARM_RIGHT = "armRight";
    private static final String BODY_FLUFF = "bodyFluff";
    private static final String LEG_LEFT = "legLeft";
    private static final String LEG_RIGHT = "legRight";
    private static final String TAIL_1 = "tail1";
    private static final String LEG_LEFT_2 = "legLeft2";
    private static final String FOOT_LEFT = "footLeft";
    private static final String LEG_RIGHT_2 = "legRight2";
    private static final String FOOT_RIGHT = "footRight";
    private static final String TAIL_2 = "tail2";
    private static final String TAIL_3 = "tail3";
    private static final String JOINT = "joint";
    private static final String NECK_FLUFF = "neckFluff";
    private static final String NECK_FLUFF_LEFT = "neckFluffLeft";
    private static final String NECK_FLUFF_RIGHT = "neckFluffRight";
    private static final String NECK_FLUFF_BOTTOM = "neckFluffBottom";
    private static final String HEAD = "head";
    private static final String EAR_LEFT = "earLeft";
    private static final String EAR_RIGHT = "earRight";
    private static final String SNOUT = "snout";
    private static final String JAW = "jaw";
    private static final String HEAD_FLUFF = "headFluff";
    private static final String HEAD_SIDEBURNS_LEFT = "headSideburnsLeft";
    private static final String HEAD_SIDEBURNS_RIGHT = "headSideburnsRight";
    private static final String EAR_LEFT_2 = "earLeft2";
    private static final String EAR_RIGHT_2 = "earRight2";
    private static final String NOSE = "nose";
    private static final String SNOUT_TEETH = "snoutTeeth";
    private static final String JAW_TEETH = "jawTeeth";
    private static final String JAW_FLUFF = "jawFluff";
    private static final String ARM_LEFT_2 = "armLeft2";
    private static final String FINGER_LEFT = "fingerLeft";
    private static final String FINGER_LEFT_2 = "fingerLeft2";
    private static final String FINGER_LEFT_3 = "fingerLeft3";
    private static final String FINGER_LEFT_4 = "fingerLeft4";
    private static final String THUMB_LEFT = "thumbLeft";
    private static final String ARM_RIGHT_2 = "armRight2";
    private static final String FINGER_RIGHT = "fingerRight";
    private static final String FINGER_RIGHT_2 = "fingerRight2";
    private static final String FINGER_RIGHT_3 = "fingerRight3";
    private static final String FINGER_RIGHT_4 = "fingerRight4";
    private static final String THUMB_RIGHT = "thumbRight";
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart armRight;
    public final ModelPart armLeft;
    public final ModelPart legRight;
    public final ModelPart legLeft;
    public final ModelPart tail1;
    public final ModelPart jaw;
    public final ModelPart earLeft;
    public final ModelPart earRight;

    public Werewolf4LModel(ModelPart part) {
        super(part);
        this.body = part.getChild(BODY);
        this.armLeft = this.body.getChild(ARM_LEFT);
        this.armRight = this.body.getChild(ARM_RIGHT);
        ModelPart hip = this.body.getChild(HIP);
        this.legLeft = hip.getChild(LEG_LEFT);
        this.legRight = hip.getChild(LEG_RIGHT);
        this.tail1 = hip.getChild(TAIL_1);
        ModelPart neck = this.body.getChild(NECK);
        ModelPart joint = neck.getChild(JOINT);
        this.head = joint.getChild(HEAD);
        this.earLeft = this.head.getChild(EAR_LEFT);
        this.earRight = this.head.getChild(EAR_RIGHT);
        this.jaw = this.head.getChild(JAW);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = WerewolfBaseModel.createMesh(CubeDeformation.NONE);
        PartDefinition part = mesh.getRoot();
        PartDefinition body = part.addOrReplaceChild(BODY, CubeListBuilder.create().texOffs(0, 13).addBox(-4.5f, 0.0f, -4.0f, 9.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.5f, (float)1.7453f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = body.addOrReplaceChild(ARM_RIGHT, CubeListBuilder.create().texOffs(36, 25).addBox(0.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)3.0f, (float)0.0f, (float)-1.3963f, (float)0.0f, (float)-0.0873f));
        PartDefinition armRight2 = armRight.addOrReplaceChild(ARM_RIGHT_2, CubeListBuilder.create().texOffs(48, 15).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)7.0f, (float)0.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition fingerRight = armRight2.addOrReplaceChild(FINGER_RIGHT, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight3 = armRight2.addOrReplaceChild(FINGER_RIGHT_3, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition thumbRight = armRight2.addOrReplaceChild(THUMB_RIGHT, CubeListBuilder.create().texOffs(0, 17).addBox(-0.5f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerRight2 = armRight2.addOrReplaceChild(FINGER_RIGHT_2, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight4 = armRight2.addOrReplaceChild(FINGER_RIGHT_4, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)1.5f, (float)0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition armLeft = body.addOrReplaceChild(ARM_LEFT, CubeListBuilder.create().texOffs(36, 25).mirror().addBox(-4.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.5f, (float)3.0f, (float)0.0f, (float)-1.3963f, (float)0.0f, (float)0.0873f));
        PartDefinition armLeft2 = armLeft.addOrReplaceChild(ARM_LEFT_2, CubeListBuilder.create().texOffs(48, 15).mirror().addBox(-1.5f, 0.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)7.0f, (float)0.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition fingerLeft4 = armLeft2.addOrReplaceChild(FINGER_LEFT_4, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)1.5f, (float)0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft3 = armLeft2.addOrReplaceChild(FINGER_LEFT_3, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition thumbLeft = armLeft2.addOrReplaceChild(THUMB_LEFT, CubeListBuilder.create().texOffs(0, 17).mirror().addBox(-1.5f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerLeft2 = armLeft2.addOrReplaceChild(FINGER_LEFT_2, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft = armLeft2.addOrReplaceChild(FINGER_LEFT, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition neck = body.addOrReplaceChild(NECK, CubeListBuilder.create().texOffs(0, 45).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)1.0f, (float)-0.4538f, (float)0.0f, (float)0.0f));
        PartDefinition neckFluff = neck.addOrReplaceChild(NECK_FLUFF, CubeListBuilder.create().texOffs(64, 19).addBox(-3.5f, -5.0f, 2.5f, 7.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition neckFluffLeft = neck.addOrReplaceChild(NECK_FLUFF_LEFT, CubeListBuilder.create().texOffs(82, 25).addBox(-3.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-1.5708f, (float)0.0f));
        PartDefinition neckFluffRight = neck.addOrReplaceChild(NECK_FLUFF_RIGHT, CubeListBuilder.create().texOffs(82, 25).addBox(-2.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)1.5708f, (float)0.0f));
        PartDefinition neckFluffBottom = neck.addOrReplaceChild(NECK_FLUFF_BOTTOM, CubeListBuilder.create().texOffs(80, 0).addBox(-3.0f, -0.6f, 4.5f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)-3.1416f, (float)0.0f));
        PartDefinition joint = neck.addOrReplaceChild(JOINT, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)-1.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition head = joint.addOrReplaceChild(HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition headSidburnRight = head.addOrReplaceChild(HEAD_SIDEBURNS_RIGHT, CubeListBuilder.create().texOffs(32, 12).mirror().addBox(1.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition snout = head.addOrReplaceChild(SNOUT, CubeListBuilder.create().texOffs(34, 0).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-5.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition nose = snout.addOrReplaceChild(NOSE, CubeListBuilder.create().texOffs(64, 0).addBox(-1.5f, -3.5f, -3.7f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition snoutTeeth = snout.addOrReplaceChild(SNOUT_TEETH, CubeListBuilder.create().texOffs(34, 6).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headSidburnLeft = head.addOrReplaceChild(HEAD_SIDEBURNS_LEFT, CubeListBuilder.create().texOffs(32, 12).addBox(-4.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition earRight = head.addOrReplaceChild(EAR_RIGHT, CubeListBuilder.create().texOffs(26, 0).addBox(3.5f, -2.5f, -2.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4187f, (float)0.3491f, (float)0.0f));
        PartDefinition earRight2 = earRight.addOrReplaceChild(EAR_RIGHT_2, CubeListBuilder.create().texOffs(26, 7).addBox(3.0f, -5.5f, -2.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition jaw = head.addOrReplaceChild(JAW, CubeListBuilder.create().texOffs(50, 0).addBox(-1.5f, 0.0f, -3.5f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)-5.0f, (float)1.2917f, (float)0.0f, (float)0.0f));
        PartDefinition jawTeeth = jaw.addOrReplaceChild(JAW_TEETH, CubeListBuilder.create().texOffs(50, 6).addBox(-1.5f, -1.0f, -3.5f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jawFluff = jaw.addOrReplaceChild(JAW_FLUFF, CubeListBuilder.create().texOffs(96, 8).addBox(-1.5f, 2.0f, -3.5f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headFluff = head.addOrReplaceChild(HEAD_FLUFF, CubeListBuilder.create().texOffs(96, 0).addBox(-3.5f, 3.5f, -5.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition earLeft = head.addOrReplaceChild(EAR_LEFT, CubeListBuilder.create().texOffs(26, 0).addBox(-4.5f, -2.5f, -2.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4187f, (float)-0.3491f, (float)0.0f));
        PartDefinition earLeft2 = earLeft.addOrReplaceChild(EAR_LEFT_2, CubeListBuilder.create().texOffs(26, 7).addBox(-4.0f, -5.5f, -2.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition bodyFluff = body.addOrReplaceChild(BODY_FLUFF, CubeListBuilder.create().texOffs(82, 14).addBox(-4.5f, 8.0f, -4.0f, 9.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hip = body.addOrReplaceChild(HIP, CubeListBuilder.create().texOffs(0, 30).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legRight = hip.addOrReplaceChild(LEG_RIGHT, CubeListBuilder.create().texOffs(24, 39).addBox(0.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)9.0f, (float)0.0f, (float)-1.309f, (float)0.0f, (float)0.0f));
        PartDefinition legRight2 = legRight.addOrReplaceChild(LEG_RIGHT_2, CubeListBuilder.create().texOffs(44, 44).addBox(0.5f, 2.0f, 3.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition footRight = legRight2.addOrReplaceChild(FOOT_RIGHT, CubeListBuilder.create().texOffs(24, 54).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)5.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft = hip.addOrReplaceChild(LEG_LEFT, CubeListBuilder.create().texOffs(24, 39).addBox(-4.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)9.0f, (float)0.0f, (float)-1.309f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft2 = legLeft.addOrReplaceChild(LEG_LEFT_2, CubeListBuilder.create().texOffs(44, 44).mirror().addBox(-3.5f, 2.0f, 3.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition footLeft = legLeft2.addOrReplaceChild(FOOT_LEFT, CubeListBuilder.create().texOffs(24, 54).mirror().addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)5.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = hip.addOrReplaceChild(TAIL_1, CubeListBuilder.create().texOffs(62, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)2.0f, (float)0.3806f, (float)0.035f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild(TAIL_2, CubeListBuilder.create().texOffs(62, 37).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild(TAIL_3, CubeListBuilder.create().texOffs(62, 49).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.8f, (float)0.0f, (float)0.1367f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    @Override
    public void setupAnim(@Nonnull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag1 = entityIn.isVisuallySwimming();
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.head.xRot, -0.7853982f, this.swimAmount) : this.rotlerpRad(this.head.xRot, headPitch * ((float)Math.PI / 180), this.swimAmount)) : headPitch * ((float)Math.PI / 180);
        this.armRight.xRot = -1.3962634f;
        this.armLeft.xRot = -1.3962634f;
        this.legRight.xRot = -1.3089969f;
        this.legLeft.xRot = -1.3089969f;
        this.armRight.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f)) * limbSwingAmount;
        this.armLeft.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f + (float)Math.PI)) * limbSwingAmount;
        this.legRight.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f)) * limbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f + (float)Math.PI)) * limbSwingAmount;
        this.tail1.xRot = 0.045553092f;
        this.tail1.xRot -= 0.035f;
        this.tail1.xRot += Mth.cos((float)(ageInTicks * 0.08f)) * 0.07f;
        this.tail1.yRot = -0.035f;
        this.tail1.yRot += Mth.sin((float)(ageInTicks * 0.12f)) * 0.03f;
        this.tail1.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f)) * 0.7f * Mth.abs((float)(limbSwingAmount * 0.6f)) + 0.3f;
        this.tail1.yRot += Mth.sin((float)(limbSwing * 0.6662f * 0.7f)) * 0.1f * limbSwingAmount * 0.6f;
        this.jaw.xRot = 1.2217305f;
        this.jaw.xRot += Mth.cos((float)(ageInTicks * 0.09f + 0.02f)) * 0.07f;
        this.earLeft.xRot = -0.4886922f;
        this.earLeft.xRot += Mth.cos((float)(ageInTicks * 0.06f + 0.01f)) * 0.07f;
        this.earRight.xRot = -0.4886922f;
        this.earRight.xRot += Mth.cos((float)(ageInTicks * 0.06f)) * 0.07f;
        if (this.attackTime > 0.0f) {
            this.jaw.xRot = 0.2f + this.attackTime * 1.0217304f;
        }
    }

    @Override
    @NotNull
    protected ModelPart getArm(@NotNull HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.armRight : this.armLeft;
    }

    public void renderToBuffer(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setRotateAngle(ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.xRot = x;
        ModelRenderer.yRot = y;
        ModelRenderer.zRot = z;
    }

    @Override
    @Nullable
    public ModelPart getModelRenderer() {
        return this.body;
    }

    @Override
    @Nullable
    public ModelPart getHeadModel() {
        return this.head;
    }

    @Override
    @Nullable
    public ModelPart getLeftArmModel() {
        return this.leftArm;
    }

    @Override
    @Nullable
    public ModelPart getRightArmModel() {
        return this.rightArm;
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    @Nonnull
    public static List<ResourceLocation> get4LTextures() {
        return WerewolfBeastModel.getBeastTextures();
    }
}

