/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.werewolves.client.core.ClientEventHandler;
import de.teamlapen.werewolves.client.core.ModBlocksRenderer;
import de.teamlapen.werewolves.client.core.ModHUDOverlay;
import de.teamlapen.werewolves.client.core.ModItemRenderer;
import de.teamlapen.werewolves.client.core.ModKeys;
import de.teamlapen.werewolves.client.core.ModModelRender;
import de.teamlapen.werewolves.client.core.ModPlayerRenderer;
import de.teamlapen.werewolves.client.core.ModScreens;
import de.teamlapen.werewolves.client.core.RenderHandler;
import de.teamlapen.werewolves.core.RegistryManager;
import de.teamlapen.werewolves.proxy.ClientProxy;
import de.teamlapen.werewolves.proxy.Proxy;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
public class WerewolvesModClient {
    private static WerewolvesModClient INSTANCE;
    private final IEventBus modEventBus;
    private final RegistryManager registryManager;
    private final ModHUDOverlay modHUDOverlay;
    private final ClientEventHandler clientEventHandler;
    private RenderHandler renderHandler;
    private ModPlayerRenderer modPlayerRenderer;

    public static WerewolvesModClient getInstance() {
        return INSTANCE;
    }

    public WerewolvesModClient(IEventBus modbus, RegistryManager registryManager) {
        INSTANCE = this;
        this.modEventBus = modbus;
        this.registryManager = registryManager;
        this.modHUDOverlay = new ModHUDOverlay();
        this.clientEventHandler = new ClientEventHandler();
        modbus.addListener(ModKeys::registerKeyMapping);
        modbus.addListener(ModModelRender::onRegisterRenderers);
        modbus.addListener(ModModelRender::onRegisterLayers);
        modbus.addListener(ModBlocksRenderer::registerBlockEntityRenderers);
        modbus.addListener(ModScreens::registerScreens);
        modbus.addListener(ModScreens::registerScreenOverlays);
        modbus.addListener(ModItemRenderer::registerColors);
        NeoForge.EVENT_BUS.register((Object)this.clientEventHandler);
        NeoForge.EVENT_BUS.register((Object)this.modHUDOverlay);
        NeoForge.EVENT_BUS.register((Object)new ModKeys(this.clientEventHandler));
    }

    @SubscribeEvent
    public void setupClient(@NotNull FMLClientSetupEvent event) {
        this.renderHandler = new RenderHandler(Minecraft.getInstance());
        this.registryManager.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        NeoForge.EVENT_BUS.register((Object)this.renderHandler);
        ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)this.renderHandler);
    }

    @SubscribeEvent
    public void onAddLayers(EntityRenderersEvent.AddLayers event) {
        this.modPlayerRenderer = new ModPlayerRenderer(event.getContext());
    }

    public ClientEventHandler getClientEventHandler() {
        return this.clientEventHandler;
    }

    public RenderHandler getRenderHandler() {
        return this.renderHandler;
    }

    public IEventBus getModEventBus() {
        return this.modEventBus;
    }

    public ModHUDOverlay getModHUDOverlay() {
        return this.modHUDOverlay;
    }

    public @UnknownNullability ModPlayerRenderer getModPlayerRenderer() {
        return this.modPlayerRenderer;
    }

    public static Proxy getProxy() {
        return new ClientProxy();
    }
}

