/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;

public abstract class WerewolfFormAction
extends DefaultWerewolfAction
implements ILastingAction<IWerewolfPlayer> {
    private static final Set<WerewolfFormAction> ALL_ACTION = new HashSet<WerewolfFormAction>();
    protected final List<Modifier> attributes = new ArrayList<Modifier>();
    @Nonnull
    private final WerewolfForm form;

    public static boolean isWerewolfFormActionActive(IActionHandler<IWerewolfPlayer> handler) {
        return ALL_ACTION.stream().anyMatch(arg_0 -> handler.isActionActive(arg_0));
    }

    public static Set<WerewolfFormAction> getAllAction() {
        return Collections.unmodifiableSet(ALL_ACTION);
    }

    public WerewolfFormAction(@Nonnull WerewolfForm form) {
        ALL_ACTION.add(this);
        this.form = form;
    }

    protected boolean activate(IWerewolfPlayer werewolf, IAction.ActivationContext context) {
        Player player = werewolf.asEntity();
        float healthPerc = player.getHealth() / player.getMaxHealth();
        if (WerewolfFormAction.isWerewolfFormActionActive((IActionHandler<IWerewolfPlayer>)werewolf.getActionHandler())) {
            FormHelper.deactivateWerewolfActions(werewolf);
        }
        ((WerewolfPlayer)werewolf).setForm(this, this.form);
        this.checkDayNightModifier(werewolf);
        player.setHealth(player.getMaxHealth() * healthPerc);
        player.refreshDisplayName();
        return true;
    }

    public void onActivatedClient(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).setForm(this, this.form);
        werewolfPlayer.asEntity().refreshDisplayName();
    }

    public void onDeactivated(IWerewolfPlayer werewolf) {
        Player player = werewolf.asEntity();
        float healthPerc = player.getHealth() / player.getMaxHealth();
        ((WerewolfPlayer)werewolf).setForm(this, WerewolfForm.NONE);
        this.removeModifier(werewolf);
        player.setHealth(player.getMaxHealth() * healthPerc);
        player.refreshDisplayName();
        if (werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.RAGE.get())) {
            werewolf.getActionHandler().deactivateAction((ILastingAction)ModActions.RAGE.get());
        }
    }

    public void onReActivated(IWerewolfPlayer werewolf) {
        ((WerewolfPlayer)werewolf).setForm(this, this.form);
        werewolf.asEntity().refreshDisplayName();
    }

    public boolean onUpdate(IWerewolfPlayer werewolfPlayer) {
        if (werewolfPlayer.asEntity().level().getGameTime() % 20L == 0L) {
            this.checkDayNightModifier(werewolfPlayer);
        }
        if (!this.usesTransformationTime(werewolfPlayer)) {
            return false;
        }
        return this.increaseWerewolfTime(werewolfPlayer) || werewolfPlayer.asEntity() instanceof ServerPlayer && (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)werewolfPlayer.asEntity()), Permissions.FORM, (PermissionDynamicContext[])new PermissionDynamicContext[0]) == false;
    }

    public boolean usesTransformationTime(IWerewolfPlayer werewolf) {
        Player player = werewolf.asEntity();
        return !Helper.isNight(player.level()) && !FormHelper.isInWerewolfBiome((LevelAccessor)player.level(), player.blockPosition());
    }

    protected boolean increaseWerewolfTime(IWerewolfPlayer werewolfPlayer) {
        if (!this.consumesWerewolfTime(werewolfPlayer)) {
            return false;
        }
        ((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime = Mth.clamp((double)(((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime + 1.0 / (double)this.getTimeModifier(werewolfPlayer)), (double)0.0, (double)1.0);
        return ((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime == 1.0;
    }

    public void checkDayNightModifier(IWerewolfPlayer werewolfPlayer) {
        boolean night = Helper.isNight(werewolfPlayer.asEntity().getCommandSenderWorld());
        this.checkDayNightModifier(werewolfPlayer, night);
    }

    protected void checkDayNightModifier(IWerewolfPlayer werewolfPlayer, boolean night) {
        Player player = werewolfPlayer.asEntity();
        float healthPerc = player.getHealth() / player.getMaxHealth();
        this.removeModifier(werewolfPlayer);
        this.applyModifier(werewolfPlayer, night);
        player.setHealth(player.getMaxHealth() * healthPerc);
    }

    public void applyModifier(IWerewolfPlayer werewolf, boolean night) {
        Player player = werewolf.asEntity();
        for (Modifier attribute : this.attributes) {
            AttributeInstance ins = player.getAttribute(attribute.attribute);
            if (ins == null || ins.getModifier(attribute.dayUuid) != null) continue;
            ins.addPermanentModifier(attribute.create(werewolf, night));
        }
    }

    public void removeModifier(IWerewolfPlayer werewolf) {
        Player player = werewolf.asEntity();
        for (Modifier attribute : this.attributes) {
            AttributeInstance ins = player.getAttribute(attribute.attribute);
            if (ins == null) continue;
            ins.removeModifier(attribute.dayUuid);
            ins.removeModifier(attribute.nightUuid);
        }
    }

    public int getDuration(IWerewolfPlayer werewolf) {
        return Integer.MAX_VALUE;
    }

    public boolean canBeUsedBy(IWerewolfPlayer werewolf) {
        Player player = werewolf.asEntity();
        if (!(!(player instanceof ServerPlayer) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), Permissions.TRANSFORMATION, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue() && ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), Permissions.FORM, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue())) {
            return false;
        }
        if (player.isPassenger() && !this.form.isHumanLike()) {
            return false;
        }
        boolean active = werewolf.getActionHandler().isActionActive((ILastingAction)this);
        if (active) {
            if (Helper.isFullMoon(player.getCommandSenderWorld())) {
                return werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.FREE_WILL.get());
            }
            return true;
        }
        if (this.form.getSize(werewolf.asEntity().getPose()).map(dimensions -> dimensions.makeBoundingBox(werewolf.asEntity().position())).filter(s -> werewolf.asEntity().level().collidesWithSuffocatingBlock((Entity)werewolf.asEntity(), s)).isPresent()) {
            return false;
        }
        if (werewolf.getForm().isTransformed()) {
            return true;
        }
        if (player.level().getBiome(player.blockPosition()).is(ModBiomes.WEREWOLF_FOREST)) {
            return true;
        }
        return ((WerewolfPlayer)werewolf).getSpecialAttributes().transformationTime < 0.7;
    }

    public boolean consumesWerewolfTime(IWerewolfPlayer werewolf) {
        return true;
    }

    public int getTimeModifier(IWerewolfPlayer werewolf) {
        int limit = (Integer)WerewolvesConfig.BALANCE.SKILLS.werewolf_form_time_limit.get() * 20;
        boolean duration1 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_GENERAL_1.get());
        boolean duration2 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_GENERAL_2.get());
        if (duration1 || duration2) {
            limit = duration2 ? (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_general_2.get() * 20) : (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_general_1.get() * 20);
        }
        return limit;
    }

    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    protected static class Modifier {
        public final Holder<Attribute> attribute;
        public final ResourceLocation dayUuid;
        public final ResourceLocation nightUuid;
        public final Function<IWerewolfPlayer, Double> value;
        public final AttributeModifier.Operation operation;
        public final double dayModifier;

        public Modifier(Holder<Attribute> attribute, ResourceLocation dayUuid, ResourceLocation nightUuid, double dayModifier, Function<IWerewolfPlayer, Double> valueFunction, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.dayUuid = dayUuid;
            this.nightUuid = nightUuid;
            this.value = valueFunction;
            this.operation = operation;
            this.dayModifier = dayModifier;
        }

        public AttributeModifier create(IWerewolfPlayer player, boolean night) {
            return new AttributeModifier(night ? this.nightUuid : this.dayUuid, night ? this.value.apply(player) : this.value.apply(player) * this.dayModifier, this.operation);
        }

        protected static class Builder {
            private final Holder<Attribute> attribute;
            private final ResourceLocation name;
            private Function<IWerewolfPlayer, Double> valueSupplier;
            private AttributeModifier.Operation operation;
            private boolean hasDayModifier;
            private double dayModifier;

            public Builder(Holder<Attribute> attribute, ResourceLocation name) {
                this.attribute = attribute;
                this.name = name;
            }

            public Builder withValues(Supplier<Double> valueSupplier, AttributeModifier.Operation operation) {
                this.valueSupplier = werewolfPlayer -> (Double)valueSupplier.get();
                this.operation = operation;
                return this;
            }

            public Builder withDayModifier(double dayModifier) {
                this.dayModifier = dayModifier;
                this.hasDayModifier = true;
                return this;
            }

            public Builder withSkillModifier(Supplier<? extends ISkill<?>> skill, Supplier<Double> valueSupplier) {
                Objects.requireNonNull(this.valueSupplier);
                Function<IWerewolfPlayer, Double> old = this.valueSupplier;
                this.valueSupplier = werewolf -> werewolf.getSkillHandler().isSkillEnabled((ISkill)skill.get()) ? (Double)valueSupplier.get() : (Double)old.apply((IWerewolfPlayer)werewolf);
                return this;
            }

            public Modifier build() {
                if (this.hasDayModifier) {
                    return new Modifier(this.attribute, this.name.withSuffix("_day"), this.name.withSuffix("_night"), this.dayModifier, this.valueSupplier, this.operation);
                }
                return new Modifier(this.attribute, this.name, this.name, 1.0, this.valueSupplier, this.operation);
            }
        }
    }

    public static class FormActionContext
    extends ActionHandler.ActivationContext {
    }
}

