/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.werewolves.api.WEnums;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.entities.AggressiveWolfEntity;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.HumanWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfAlphaEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTaskMasterEntity;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"werewolves");
    public static final DeferredHolder<EntityType<?>, EntityType<BasicWerewolfEntity.Beast>> WEREWOLF_BEAST = ModEntities.prepareEntityType("werewolf_beast", () -> EntityType.Builder.of(BasicWerewolfEntity.Beast::new, (MobCategory)((MobCategory)WEnums.WEREWOLF_CATEGORY.getValue())).sized(0.8f, 2.0f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<BasicWerewolfEntity.Survivalist>> WEREWOLF_SURVIVALIST = ModEntities.prepareEntityType("werewolf_survivalist", () -> EntityType.Builder.of(BasicWerewolfEntity.Survivalist::new, (MobCategory)((MobCategory)WEnums.WEREWOLF_CATEGORY.getValue())).sized(0.8f, 1.0f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<HumanWerewolfEntity>> HUMAN_WEREWOLF = ModEntities.prepareEntityType("human_werewolf", () -> EntityType.Builder.of(HumanWerewolfEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.9f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<WerewolfTaskMasterEntity>> TASK_MASTER_WEREWOLF = ModEntities.prepareEntityType("task_master_werewolf", () -> EntityType.Builder.of(WerewolfTaskMasterEntity::new, (MobCategory)((MobCategory)WEnums.WEREWOLF_CATEGORY.getValue())).sized(0.6f, 1.95f), true);
    public static final DeferredHolder<EntityType<?>, EntityType<AggressiveWolfEntity>> WOLF = ModEntities.prepareEntityType("wolf", () -> EntityType.Builder.of(AggressiveWolfEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.6f, 0.85f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<WerewolfMinionEntity>> WEREWOLF_MINION = ModEntities.prepareEntityType("werewolf_minion", () -> EntityType.Builder.of(WerewolfMinionEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.95f), false);
    public static final DeferredHolder<EntityType<?>, EntityType<WerewolfAlphaEntity>> ALPHA_WEREWOLF = ModEntities.prepareEntityType("alpha_werewolf", () -> EntityType.Builder.of(WerewolfAlphaEntity::new, (MobCategory)((MobCategory)WEnums.WEREWOLF_CATEGORY.getValue())).sized(0.8f, 2.0f), true);

    static void register(IEventBus bus) {
        ENTITY_TYPES.register(bus);
    }

    static void registerSpawns(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)WEREWOLF_BEAST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)WEREWOLF_SURVIVALIST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)HUMAN_WEREWOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HumanWerewolfEntity::spawnPredicateHumanWerewolf, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)WOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, spawnReason, blockPos, random) -> true, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)ALPHA_WEREWOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WerewolfAlphaEntity::spawnPredicateAlpha, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> prepareEntityType(String id, Supplier<EntityType.Builder<T>> builder, boolean spawnable) {
        return ENTITY_TYPES.register(id, () -> {
            EntityType.Builder type = ((EntityType.Builder)builder.get()).setTrackingRange(10).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
            if (!spawnable) {
                type.noSummon();
            }
            return type.build("werewolves:" + id);
        });
    }

    static void onRegisterEntityTypeAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HUMAN_WEREWOLF.get(), HumanWerewolfEntity.getAttributeBuilder().build());
        event.put((EntityType)WEREWOLF_BEAST.get(), BasicWerewolfEntity.getAttributeBuilder().build());
        event.put((EntityType)WEREWOLF_SURVIVALIST.get(), BasicWerewolfEntity.getAttributeBuilder().build());
        event.put((EntityType)WOLF.get(), AggressiveWolfEntity.createAttributes().build());
        event.put((EntityType)TASK_MASTER_WEREWOLF.get(), WerewolfTaskMasterEntity.getAttributeBuilder().build());
        event.put((EntityType)WEREWOLF_MINION.get(), WerewolfMinionEntity.getAttributeBuilder().build());
        event.put((EntityType)ALPHA_WEREWOLF.get(), WerewolfAlphaEntity.getAttributeBuilder().build());
    }

    static void onModifyEntityTypeAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, ModAttributes.BITE_DAMAGE);
        event.add(EntityType.PLAYER, ModAttributes.TIME_REGAIN);
        event.add(EntityType.PLAYER, ModAttributes.FOOD_CONSUMPTION);
        event.add(EntityType.PLAYER, ModAttributes.FOOD_GAIN);
    }

    public static Set<EntityType<?>> getAllEntities() {
        return ENTITY_TYPES.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toSet());
    }

    static {
        V.init();
    }

    public static class V {
        public static final DeferredHolder<EntityType<?>, EntityType<BasicHunterEntity>> HUNTER = DeferredHolder.create((ResourceKey)ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)WResourceLocation.v("hunter")));
        public static final DeferredHolder<EntityType<?>, EntityType<BasicHunterEntity.IMob>> HUNTER_IMOB = DeferredHolder.create((ResourceKey)ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)WResourceLocation.v("hunter_imob")));

        private static void init() {
        }
    }
}

