package de.teamlapen.werewolves.data;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.data.recipebuilder.AlchemicalCauldronRecipeBuilder;
import de.teamlapen.vampirism.data.recipebuilder.AlchemyTableRecipeBuilder;
import de.teamlapen.vampirism.data.recipebuilder.ShapedWeaponTableRecipeBuilder;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModOils;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.util.REFERENCE;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.*;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.*;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class RecipeGenerator extends RecipeProvider {

    protected static final ImmutableList<ItemLike> SILVER_SMELTABLES = ImmutableList.of(ModBlocks.SILVER_ORE.get(), ModBlocks.DEEPSLATE_SILVER_ORE.get(), ModItems.RAW_SILVER.get());

    public RecipeGenerator(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(packOutput, pRegistries);
    }

    private static ResourceLocation modId(String name) {
        return WResourceLocation.mod(name);
    }

    @Override
    protected void buildRecipes(@Nonnull RecipeOutput consumer) {
        TagKey<Item> sticks = Tags.Items.RODS_WOODEN;
        TagKey<Item> silver_ingot = ModTags.Items.SILVER_INGOT;
        TagKey<Item> silver_nugget = ModTags.Items.SILVER_NUGGET;
        TagKey<Item> raw_silver = ModTags.Items.RAW_MATERIALS_SILVER;
        TagKey<Item> iron_ingot = Tags.Items.INGOTS_IRON;
        TagKey<Item> feathers = Tags.Items.FEATHERS;
        ItemLike crossbow_arrow = ModItems.V.CROSSBOW_ARROW_NORMAL.get();
        TagKey<Item> planks = ItemTags.PLANKS;
        TagKey<Item> diamond = Tags.Items.GEMS_DIAMOND;
        TagKey<Item> obsidian = Tags.Items.OBSIDIANS;
        ItemLike wolfsbane_diffuser_core = ModItems.WOLFSBANE_DIFFUSER_CORE.get();
        ItemLike wolfsbane_diffuser_core_improved = ModItems.WOLFSBANE_DIFFUSER_CORE_IMPROVED.get();
        ItemLike wolfsbane_diffuser = ModBlocks.WOLFSBANE_DIFFUSER.get();
        TagKey<Item> wool = ItemTags.WOOL;
        ItemLike wolfsbane = ModBlocks.WOLFSBANE.get();
        ItemLike pelt = ModItems.PELT.get();
        ItemLike dark_pelt = ModItems.DARK_PELT.get();


        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.BONE, 2)
                .requires(ModItems.CRACKED_BONE.get()).unlockedBy("has_broken_bone", has(ModItems.CRACKED_BONE.get()))
                .save(consumer, WResourceLocation.mod("bone"));
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.PURPLE_DYE)
                .requires(ModBlocks.WOLFSBANE.get()).unlockedBy("has_wolfsbane", has(ModBlocks.WOLFSBANE.get()))
                .save(consumer, WResourceLocation.mod("purple_dye"));

        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, ModItems.SILVER_HOE.get()).pattern("XX").pattern(" #").pattern(" #")
                .define('#', sticks).unlockedBy("has_sticks", has(sticks))
                .define('X', silver_ingot).unlockedBy("has_silver_ingot", has(silver_ingot))
                .save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC,ModItems.SILVER_SHOVEL.get()).pattern("X").pattern("#").pattern("#")
                .define('#', sticks).unlockedBy("has_sticks", has(sticks))
                .define('X', silver_ingot).unlockedBy("has_silver_ingot", has(silver_ingot))
                .save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC,ModItems.SILVER_SWORD.get()).pattern("X").pattern("X").pattern("#")
                .define('#', sticks).unlockedBy("has_sticks", has(sticks))
                .define('X', silver_ingot).unlockedBy("has_silver_ingot", has(silver_ingot))
                .save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC,ModItems.SILVER_AXE.get()).pattern("XX").pattern("X#").pattern(" #")
                .define('#', sticks).unlockedBy("has_sticks", has(sticks))
                .define('X', silver_ingot).unlockedBy("has_silver_ingot", has(silver_ingot))
                .save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC,ModItems.SILVER_PICKAXE.get()).pattern("XXX").pattern(" # ").pattern(" # ")
                .define('#', sticks).unlockedBy("has_sticks", has(sticks))
                .define('X', silver_ingot).unlockedBy("has_silver_ingot", has(silver_ingot))
                .save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC,ModBlocks.STONE_ALTAR.get()).pattern("S S").pattern("SSS").pattern("SSS")
                .define('S', Items.STONE_BRICKS).unlockedBy("has_stone_bricks", has(Items.STONE_BRICKS))
                .save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC,ModBlocks.STONE_ALTAR_FIRE_BOWL.get()).pattern("SPS").pattern("SSS").pattern(" S ")
                .define('S', Items.STONE_BRICKS).unlockedBy("has_stone_bricks", has(Items.STONE_BRICKS))
                .define('P', ItemTags.PLANKS).unlockedBy("has_planks", has(ItemTags.PLANKS))
                .save(consumer);
        nineBlockStorageRecipes(consumer, RecipeCategory.MISC, ModItems.SILVER_INGOT.get(), RecipeCategory.MISC, ModBlocks.SILVER_BLOCK.get(), REFERENCE.MODID + ":silver_block_from_silver_ingot", null, REFERENCE.MODID + ":silver_ingot_from_silver_block", null);
        nineBlockStorageRecipes(consumer, RecipeCategory.MISC, ModItems.RAW_SILVER.get(), RecipeCategory.MISC, ModBlocks.RAW_SILVER_BLOCK.get(), REFERENCE.MODID + ":raw_silver_block_from_raw_silver_ingot", null, REFERENCE.MODID + ":raw_silver_ingot_from_raw_silver_block", null);
        nineBlockStorageRecipes(consumer, RecipeCategory.MISC, ModItems.SILVER_NUGGET.get(), RecipeCategory.MISC, ModItems.SILVER_INGOT.get(), REFERENCE.MODID + ":silver_ingot_from_nuggets", null, REFERENCE.MODID + ":silver_nugget_from_ingot", null);
        oreSmelting(consumer, SILVER_SMELTABLES, RecipeCategory.MISC, ModItems.SILVER_INGOT.get(), 0.7f, 200, "silver_ingot");
        oreBlasting(consumer, SILVER_SMELTABLES, RecipeCategory.MISC, ModItems.SILVER_INGOT.get(), 0.7f, 100, "silver_ingot");
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(ModItems.SILVER_AXE.get(), ModItems.SILVER_HOE.get(), ModItems.SILVER_PICKAXE.get(), ModItems.SILVER_SHOVEL.get(), ModItems.SILVER_SWORD.get()), RecipeCategory.MISC, ModItems.SILVER_NUGGET.get(), 0.1f, 200).unlockedBy("has_silver_axe", has(ModItems.SILVER_AXE.get())).unlockedBy("has_silver_hoe", has(ModItems.SILVER_HOE.get())).unlockedBy("has_silver_pickaxe", has(ModItems.SILVER_PICKAXE.get())).unlockedBy("has_silver_shovel", has(ModItems.SILVER_SHOVEL.get())).unlockedBy("has_silver_sword", has(ModItems.SILVER_SWORD.get())).save(consumer, WResourceLocation.mod(getSmeltingRecipeName(ModItems.SILVER_NUGGET.get())));
        SimpleCookingRecipeBuilder.blasting(Ingredient.of(ModItems.SILVER_AXE.get(), ModItems.SILVER_HOE.get(), ModItems.SILVER_PICKAXE.get(), ModItems.SILVER_SHOVEL.get(), ModItems.SILVER_SWORD.get()), RecipeCategory.MISC, ModItems.SILVER_NUGGET.get(), 0.1f, 100).unlockedBy("has_silver_axe", has(ModItems.SILVER_AXE.get())).unlockedBy("has_silver_hoe", has(ModItems.SILVER_HOE.get())).unlockedBy("has_silver_pickaxe", has(ModItems.SILVER_PICKAXE.get())).unlockedBy("has_silver_shovel", has(ModItems.SILVER_SHOVEL.get())).unlockedBy("has_silver_sword", has(ModItems.SILVER_SWORD.get())).save(consumer, WResourceLocation.mod(getBlastingRecipeName(ModItems.SILVER_NUGGET.get())));

        ShapedWeaponTableRecipeBuilder.shapedWeaponTable(RecipeCategory.MISC,ModItems.CROSSBOW_ARROW_SILVER_BOLT.get(), 3).pattern(" X ").pattern("XYX").pattern(" S ").pattern(" F ")
                .lava(1)
                .define('S', sticks).unlockedBy("hasSticks", has(sticks))
                .define('X', silver_nugget).unlockedBy("has_silver_nugget", has(silver_nugget))
                .define('F', feathers).unlockedBy("has_feathers", has(feathers))
                .define('Y', iron_ingot).unlockedBy("has_iron", has(iron_ingot))
                .unlockedBy("has_crossbow_arrow", has(crossbow_arrow))
                .save(consumer, modId("crossbow_arrow_silver_bolt"));

        AlchemyTableRecipeBuilder
                .builder(ModOils.SILVER_OIL_1)
                .bloodOilIngredient()
                .input(Ingredient.of(ModTags.Items.SILVER_INGOT)).unlockedBy("has_silver_ingot", has(ModTags.Items.SILVER_INGOT))
                .save(consumer, modId("silver_oil_1"));
        AlchemyTableRecipeBuilder
                .builder(ModOils.SILVER_OIL_2)
                .oilIngredient(ModOils.SILVER_OIL_1).unlockedBy("has_silver_oil_1", has(de.teamlapen.vampirism.core.ModItems.OIL_BOTTLE.get()))
                .input(Ingredient.of(ModTags.Items.SILVER_INGOT)).unlockedBy("has_silver_ingot", has(ModTags.Items.SILVER_INGOT))
                .save(consumer, modId("silver_oil_2"));

        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.SILVER_HELMET.get()).define('X', silver_ingot).pattern("XXX").pattern("X X").unlockedBy("has_silver_ingot", has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.SILVER_CHESTPLATE.get()).define('X', silver_ingot).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_silver_ingot", has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.SILVER_LEGGINGS.get()).define('X', silver_ingot).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_silver_ingot", has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.SILVER_BOOTS.get()).define('X', silver_ingot).pattern("X X").pattern("X X").unlockedBy("has_silver_ingot", has(silver_ingot)).save(consumer);

        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.YELLOW_DYE).requires(ModBlocks.DAFFODIL.get()).unlockedBy("has_daffodil", has(ModBlocks.DAFFODIL.get())).save(consumer, modId("daffodil_yellow_dye"));

        generateRecipes(consumer, ModBlockFamilies.JACARANDA_PLANKS, FeatureFlagSet.of(FeatureFlags.VANILLA));
        generateRecipes(consumer, ModBlockFamilies.MAGIC_PLANKS, FeatureFlagSet.of(FeatureFlags.VANILLA));

        planksFromLog(consumer, ModBlocks.JACARANDA_PLANKS.get(), ModTags.Items.JACARANDA_LOG, 4);
        planksFromLog(consumer, ModBlocks.MAGIC_PLANKS.get(), ModTags.Items.MAGIC_LOG, 4);
        woodFromLogs(consumer, ModBlocks.JACARANDA_WOOD.get(), ModBlocks.JACARANDA_LOG.get());
        woodFromLogs(consumer, ModBlocks.MAGIC_WOOD.get(), ModBlocks.MAGIC_LOG.get());
        woodFromLogs(consumer, ModBlocks.STRIPPED_JACARANDA_WOOD.get(), ModBlocks.STRIPPED_JACARANDA_LOG.get());
        woodFromLogs(consumer, ModBlocks.STRIPPED_MAGIC_WOOD.get(), ModBlocks.STRIPPED_MAGIC_LOG.get());
        woodenBoat(consumer, ModItems.JACARANDA_BOAT.get(), ModBlocks.JACARANDA_PLANKS.get());
        woodenBoat(consumer, ModItems.MAGIC_BOAT.get(), ModBlocks.MAGIC_PLANKS.get());
        chestBoat(consumer, ModItems.JACARANDA_CHEST_BOAT.get(), ModBlocks.JACARANDA_PLANKS.get());
        chestBoat(consumer, ModItems.MAGIC_CHEST_BOAT.get(), ModBlocks.MAGIC_PLANKS.get());

        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, ModBlocks.WOLFSBANE_DIFFUSER_LONG.get()).pattern("XYX").pattern("YZY").pattern("OOO").define('X', planks).define('Y', diamond).define('O', obsidian).define('Z', wolfsbane_diffuser_core).unlockedBy("has_diamond", has(diamond)).save(consumer, WResourceLocation.mod("wolfsbane_diffuser_normal"));
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, ModBlocks.WOLFSBANE_DIFFUSER.get()).pattern("XYX").pattern("YZY").pattern("OOO").define('X', planks).define('Y', diamond).define('O', obsidian).define('Z', wolfsbane_diffuser_core_improved).unlockedBy("has_garlic_diffuser", has(wolfsbane_diffuser)).unlockedBy("has_diamond", has(diamond)).save(consumer, WResourceLocation.mod("wolfsbane_diffuser_improved"));
        AlchemicalCauldronRecipeBuilder.cauldronRecipe(ModItems.WOLFSBANE_DIFFUSER_CORE.get()).withIngredient(wool).withFluid(wolfsbane).withSkills(HunterSkills.GARLIC_DIFFUSER.get()).save(consumer, modId("wolfsbane_diffuser_core"));
        AlchemicalCauldronRecipeBuilder.cauldronRecipe(ModItems.WOLFSBANE_DIFFUSER_CORE_IMPROVED.get()).withIngredient(wolfsbane_diffuser_core).withFluid(wolfsbane).withSkills(HunterSkills.GARLIC_DIFFUSER_IMPROVED.get()).experience(2.0f).save(consumer, modId("wolfsbane_diffuser_core_improved"));
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.PELT_HELMET.get()).define('P', pelt).pattern("PPP").pattern("P P").unlockedBy("has_pelt", has(pelt)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.PELT_CHESTPLATE.get()).define('P', pelt).pattern("P P").pattern("PPP").pattern("PPP").unlockedBy("has_pelt", has(pelt)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.PELT_LEGGINGS.get()).define('P', pelt).pattern("PPP").pattern("P P").pattern("P P").unlockedBy("has_pelt", has(pelt)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.PELT_BOOTS.get()).define('P', pelt).pattern("P P").pattern("P P").unlockedBy("has_pelt", has(pelt)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.DARK_PELT_HELMET.get()).define('P', dark_pelt).pattern("PPP").pattern("P P").unlockedBy("has_pelt", has(dark_pelt)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.DARK_PELT_CHESTPLATE.get()).define('P', dark_pelt).pattern("P P").pattern("PPP").pattern("PPP").unlockedBy("has_pelt", has(dark_pelt)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.DARK_PELT_LEGGINGS.get()).define('P', dark_pelt).pattern("PPP").pattern("P P").pattern("P P").unlockedBy("has_pelt", has(dark_pelt)).save(consumer);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, ModItems.DARK_PELT_BOOTS.get()).define('P', dark_pelt).pattern("P P").pattern("P P").unlockedBy("has_pelt", has(dark_pelt)).save(consumer);
        SmithingTransformRecipeBuilder.smithing(Ingredient.of(ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()), Ingredient.of(ModItems.DARK_PELT_HELMET.get()), Ingredient.of(ModItems.WHITE_PELT.get()), RecipeCategory.COMBAT, ModItems.WHITE_PELT_HELMET.get()).unlocks("has_white_pelt", has(ModItems.WHITE_PELT.get())).save(consumer, getItemNameFull(ModItems.WHITE_PELT_HELMET.get()) + "_smithing");
        SmithingTransformRecipeBuilder.smithing(Ingredient.of(ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()), Ingredient.of(ModItems.DARK_PELT_CHESTPLATE.get()), Ingredient.of(ModItems.WHITE_PELT.get()), RecipeCategory.COMBAT, ModItems.WHITE_PELT_CHESTPLATE.get()).unlocks("has_white_pelt", has(ModItems.WHITE_PELT.get())).save(consumer, getItemNameFull(ModItems.WHITE_PELT_CHESTPLATE.get()) + "_smithing");
        SmithingTransformRecipeBuilder.smithing(Ingredient.of(ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()), Ingredient.of(ModItems.DARK_PELT_LEGGINGS.get()), Ingredient.of(ModItems.WHITE_PELT.get()), RecipeCategory.COMBAT, ModItems.WHITE_PELT_LEGGINGS.get()).unlocks("has_white_pelt", has(ModItems.WHITE_PELT.get())).save(consumer, getItemNameFull(ModItems.WHITE_PELT_LEGGINGS.get()) + "_smithing");
        SmithingTransformRecipeBuilder.smithing(Ingredient.of(ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()), Ingredient.of(ModItems.DARK_PELT_BOOTS.get()), Ingredient.of(ModItems.WHITE_PELT.get()), RecipeCategory.COMBAT, ModItems.WHITE_PELT_BOOTS.get()).unlocks("has_white_pelt", has(ModItems.WHITE_PELT.get())).save(consumer, getItemNameFull(ModItems.WHITE_PELT_BOOTS.get()) + "_smithing");
        copySmithingTemplate(consumer, ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get(), ModItems.WEREWOLF_TOOTH.get());
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, ModItems.WOLFSBANE_FINDER.get()).pattern("XXX").pattern("XYX").pattern("ZAZ").define('X', silver_ingot).define('Y', wolfsbane).define('Z', planks).define('A', Tags.Items.DUSTS_REDSTONE).unlockedBy("has_redstone", has(Tags.Items.DUSTS_REDSTONE)).unlockedBy("has_silver_ingot", has(silver_ingot)).save(consumer);
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(
            RecipeOutput pRecipeOutput,
            RecipeSerializer<T> pSerializer,
            AbstractCookingRecipe.Factory<T> pRecipeFactory,
            List<ItemLike> pIngredients,
            RecipeCategory pCategory,
            ItemLike pResult,
            float pExperience,
            int pCookingTime,
            String pGroup,
            String pSuffix
    ) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic(Ingredient.of(itemlike), pCategory, pResult, pExperience, pCookingTime, pSerializer, pRecipeFactory)
                    .group(pGroup)
                    .unlockedBy(getHasName(itemlike), has(itemlike))
                    .save(pRecipeOutput, getItemNameFull(pResult) + pSuffix + "_" + getItemName(itemlike));
        }
    }

    protected static String getItemNameFull(ItemLike pItemLike) {
        return BuiltInRegistries.ITEM.getKey(pItemLike.asItem()).toString();
    }

    protected static void oreSmelting(
            RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup
    ) {
        oreCooking(
                pRecipeOutput,
                RecipeSerializer.SMELTING_RECIPE,
                SmeltingRecipe::new,
                pIngredients,
                pCategory,
                pResult,
                pExperience,
                pCookingTime,
                pGroup,
                "_from_smelting"
        );
    }

    protected static void oreBlasting(
            RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup
    ) {
        oreCooking(
                pRecipeOutput,
                RecipeSerializer.BLASTING_RECIPE,
                BlastingRecipe::new,
                pIngredients,
                pCategory,
                pResult,
                pExperience,
                pCookingTime,
                pGroup,
                "_from_blasting"
        );
    }
}
