/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.event.VampirismVillageEvent;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;

public class ModWorldEventHandler {
    @SubscribeEvent
    public void onVillageCaptureFinish(VampirismVillageEvent.VillagerCaptureFinish.Pre event) {
        Level world = ((BlockEntity)event.getTotem()).getLevel();
        List werewolves = world.getEntitiesOfClass(Mob.class, event.getVillageArea(), WerewolfTransformable.class::isInstance);
        if (WReference.WEREWOLF_FACTION.equals((Object)event.getControllingFaction())) {
            werewolves.forEach(e -> {
                if (((WerewolfTransformable)e).canTransform()) {
                    ((WerewolfTransformable)e).transformBack();
                } else if (event.isForced() && event.getCapturingFaction() != null) {
                    this.getCaptureEntity(event.getCapturingFaction(), world).ifPresent(mob -> this.spawnEntity(world, (Mob)mob, (Mob)e, true));
                }
            });
        } else {
            for (Mob werewolf : werewolves) {
                if (!(werewolf instanceof IVillagerTransformable)) continue;
                ((IVillagerTransformable)werewolf).transformBack();
                ((IVillagerTransformable)werewolf).setWerewolfFaction(false);
            }
        }
    }

    @SubscribeEvent
    public void onVillageSpawnNewVillager(VampirismVillageEvent.SpawnNewVillager event) {
        if (event.getControllingFaction() == WReference.WEREWOLF_FACTION && event.getNewVillager().getRandom().nextInt(6) == 0) {
            ((IVillagerTransformable)event.getNewVillager()).setWerewolfFaction(true);
        }
    }

    @SubscribeEvent
    public void onVillageMakeAggressive(VampirismVillageEvent.MakeAggressive event) {
        if (event.getControllingFaction() == WReference.WEREWOLF_FACTION && ((IVillagerTransformable)event.getOldVillager()).canTransform()) {
            event.setCanceled(true);
            ((IVillagerTransformable)event.getOldVillager()).transformToWerewolf(TransformType.RAID);
        }
    }

    private void spawnEntity(Level world, Mob newEntity, Mob oldEntity, boolean replaceOld) {
        newEntity.restoreFrom((Entity)oldEntity);
        newEntity.setUUID(Mth.createInsecureUUID());
        if (replaceOld) {
            oldEntity.remove(Entity.RemovalReason.DISCARDED);
        }
        world.addFreshEntity((Entity)newEntity);
    }

    private Optional<Mob> getCaptureEntity(IFaction<?> faction, Level world) {
        List entries = faction.getVillageData().getCaptureEntries();
        return WeightedRandom.getRandomItem((RandomSource)world.getRandom(), (List)entries).map(entry -> (Mob)entry.getEntity().create(world));
    }
}

