/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.modcompat.guide;

import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.BookHelper;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.category.CategoryItemStack;
import de.maxanier.guideapi.page.PageHolderWithLinks;
import de.maxanier.guideapi.page.PageTextImage;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.modcompat.guide.EntryText;
import de.teamlapen.vampirism.modcompat.guide.GuideBook;
import de.teamlapen.vampirism.modcompat.guide.VampirismGuideBookCategoriesEvent;
import de.teamlapen.vampirism.modcompat.guide.pages.PageTable;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfLevelConf;
import de.teamlapen.werewolves.items.LiverItem;
import de.teamlapen.werewolves.items.WerewolfMinionUpgradeItem;
import de.teamlapen.werewolves.items.WerewolfToothItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class WerewolvesGuideBook {
    private static final String IMAGE_BASE = "vampirismguide:textures/images/";

    public static void onVampirismGuideBookCategoriesEvent(VampirismGuideBookCategoriesEvent event) {
        BookHelper helper = new BookHelper.Builder("werewolves").build();
        int werewolfPos = -1;
        int itemPos = -1;
        int blockPos = -1;
        for (int i1 = 0; i1 < event.categories.size(); ++i1) {
            if (werewolfPos == -1 && ((CategoryAbstract)event.categories.get((int)i1)).entries.keySet().stream().findAny().map(t -> t.getPath().contains("guide.vampirism.hunter")).orElse(false).booleanValue()) {
                werewolfPos = i1 + 1;
                continue;
            }
            if (itemPos == -1 && ((CategoryAbstract)event.categories.get((int)i1)).entries.keySet().stream().findAny().map(t -> t.getPath().contains("guide.vampirism.items")).orElse(false).booleanValue()) {
                itemPos = i1 + 1;
                continue;
            }
            if (blockPos != -1 || !((CategoryAbstract)event.categories.get((int)i1)).entries.keySet().stream().findAny().map(t -> t.getPath().contains("guide.vampirism.blocks")).orElse(false).booleanValue()) continue;
            blockPos = i1 + 1;
        }
        if (werewolfPos < 0) {
            werewolfPos = event.categories.size();
        }
        CategoryItemStack category = new CategoryItemStack(WerewolvesGuideBook.buildWerewolf(helper), (Component)GuideBook.translateComponent((String)"guide.werewolves.entity.werewolf.title", (Object[])new Object[0]), ((LiverItem)((Object)ModItems.LIVER.get())).getDefaultInstance());
        helper.registerLinkablePages(Collections.singletonList(category));
        event.categories.add(werewolfPos, category);
        if (itemPos >= 0) {
            CategoryAbstract items = (CategoryAbstract)event.categories.get(itemPos);
            WerewolvesGuideBook.buildItems(items.entries, helper);
            helper.registerLinkablePages(Collections.singletonList(items));
        }
        if (blockPos >= 0) {
            CategoryAbstract blocks = (CategoryAbstract)event.categories.get(blockPos);
            WerewolvesGuideBook.buildBlocks(blocks.entries, helper);
            helper.registerLinkablePages(Collections.singletonList(blocks));
        }
    }

    private static Map<ResourceLocation, EntryAbstract> buildWerewolf(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.werewolves.werewolf.";
        ArrayList gettingStarted = new ArrayList();
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "getting_started.become"), (Object[])new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "getting_started.as_werewolf"), (Object[])new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "getting_started.weakness"), (Object[])new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "getting_started.skills"), (Object[])new Object[0])));
        entries.put(WResourceLocation.mod(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, (Component)GuideBook.translateComponent((String)(base + "getting_started"), (Object[])new Object[0])));
        ArrayList<Object> levelingPages = new ArrayList<Object>();
        levelingPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "leveling.intro"), (Object[])new Object[0])));
        String stone_altar = "\u00a7l" + String.valueOf(WerewolvesGuideBook.loc((Block)ModBlocks.STONE_ALTAR.get())) + "\u00a7r\n\u00a7o" + GuideBook.translate((String)(base + "leveling.stone.reach"), (Object[])new Object[0]) + "\u00a7r\n";
        stone_altar = stone_altar + GuideBook.translate((String)(base + "leveling.stone.intro"), (Object[])new Object[]{WerewolvesGuideBook.loc(Items.FLINT_AND_STEEL), WerewolvesGuideBook.loc(Items.TORCH)});
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)Component.literal((String)stone_altar)), new Object[]{WResourceLocation.mod("guide.werewolves.blocks.stone_altar"), WResourceLocation.mod("guide.werewolves.blocks.stone_altar_fire_bowl")}));
        levelingPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "leveling.stone.structure"), (Object[])new Object[]{WerewolvesGuideBook.loc((Block)ModBlocks.STONE_ALTAR.get()), WerewolvesGuideBook.loc((Block)ModBlocks.STONE_ALTAR_FIRE_BOWL.get()), WerewolvesGuideBook.loc((Block)ModBlocks.STONE_ALTAR.get()), WerewolvesGuideBook.loc((Block)ModBlocks.STONE_ALTAR_FIRE_BOWL.get()), WerewolvesGuideBook.loc(Items.FLINT_AND_STEEL)})));
        levelingPages.add(new PageTextImage((FormattedText)GuideBook.translateComponent((String)(base + "leveling.stone.image1"), (Object[])new Object[0]), WResourceLocation.mod("vampirismguide:textures/images/stone1.png"), false));
        String item = String.valueOf(WerewolvesGuideBook.loc((Item)ModItems.LIVER.get())) + ", " + String.valueOf(WerewolvesGuideBook.loc((Item)ModItems.CRACKED_BONE.get()));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "leveling.stone.items"), (Object[])new Object[]{item})), new Object[]{WResourceLocation.mod("guide.werewolves.items.liver"), WResourceLocation.mod("guide.werewolves.items.cracked_bone"), WResourceLocation.mod("guide.werewolves.werewolf.slayed_creatures")}));
        PageTable.Builder requirementBuilder = new PageTable.Builder(4);
        requirementBuilder.addLine(new Component[]{Component.translatable((String)"text.vampirism.level_short"), WerewolvesGuideBook.loc((Item)ModItems.LIVER.get()), WerewolvesGuideBook.loc((Item)ModItems.CRACKED_BONE.get()), Component.translatable((String)"text.werewolves.slayed_creatures")});
        for (int i = 2; i <= 14; ++i) {
            WerewolfLevelConf.StoneAltarRequirement req = WerewolfLevelConf.getInstance().getStoneRequirement(i);
            requirementBuilder.addLine(new Object[]{i, req.liverAmount, req.bonesAmount, req.xpAmount});
        }
        requirementBuilder.setHeadline(GuideBook.translateComponent((String)(base + "leveling.stone_req"), (Object[])new Object[0]));
        PageHolderWithLinks requirementTable = new PageHolderWithLinks(helper, (IPage)requirementBuilder.build());
        requirementTable.addLink(WResourceLocation.mod("guide.werewolves.items.liver"));
        requirementTable.addLink(WResourceLocation.mod("guide.werewolves.items.cracked_bone"));
        requirementTable.addLink(WResourceLocation.mod("guide.werewolves.werewolf.slayed_creatures"));
        levelingPages.add(requirementTable);
        entries.put(WResourceLocation.mod(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, (Component)GuideBook.translateComponent((String)(base + "leveling"), (Object[])new Object[0])));
        ArrayList skillPages = new ArrayList();
        skillPages.addAll(PageHelper.pagesForLongText((FormattedText)Component.translatable((String)(base + "skills.text"), (Object[])new Object[]{Component.translatable((String)ModKeys.SUCK.saveString())})));
        skillPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "skills.decision"), (Object[])new Object[0])));
        entries.put(WResourceLocation.mod(base + "skills"), (EntryAbstract)new EntryText(skillPages, (Component)GuideBook.translateComponent((String)(base + "skills"), (Object[])new Object[0])));
        ArrayList<PageTable> werewolfLord = new ArrayList<PageTable>();
        werewolfLord.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "lord.text"), (Object[])new Object[]{((EntityType)ModEntities.TASK_MASTER_WEREWOLF.get()).getDescription(), WReference.WEREWOLF_FACTION.getLordTitle(1, IPlayableFaction.TitleGender.UNKNOWN), WReference.WEREWOLF_FACTION.getLordTitle(WReference.WEREWOLF_FACTION.getHighestLordLevel(), IPlayableFaction.TitleGender.UNKNOWN)})), new Object[]{WResourceLocation.mod("guide.vampirism.entity.taskmaster")}));
        PageTable.Builder lordTitleBuilder = new PageTable.Builder(2).setHeadline(GuideBook.translateComponent((String)(base + "lord.titles"), (Object[])new Object[0]));
        lordTitleBuilder.addLine(new Component[]{Component.translatable((String)"text.vampirism.level"), Component.translatable((String)"text.vampirism.title")});
        lordTitleBuilder.addLine(new Object[]{1, WReference.WEREWOLF_FACTION.getLordTitle(1, IPlayableFaction.TitleGender.UNKNOWN).getString()});
        lordTitleBuilder.addLine(new Object[]{2, WReference.WEREWOLF_FACTION.getLordTitle(2, IPlayableFaction.TitleGender.UNKNOWN).getString()});
        lordTitleBuilder.addLine(new Object[]{3, WReference.WEREWOLF_FACTION.getLordTitle(3, IPlayableFaction.TitleGender.UNKNOWN).getString()});
        lordTitleBuilder.addLine(new Object[]{4, WReference.WEREWOLF_FACTION.getLordTitle(4, IPlayableFaction.TitleGender.UNKNOWN).getString()});
        lordTitleBuilder.addLine(new Object[]{5, WReference.WEREWOLF_FACTION.getLordTitle(5, IPlayableFaction.TitleGender.UNKNOWN).getString()});
        werewolfLord.add(lordTitleBuilder.build());
        werewolfLord.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "lord.minion"), (Object[])new Object[]{WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_CHARM.get()), WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE.get()), WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED.get()), WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL.get())})), new Object[]{WResourceLocation.mod("guide.werewolves.items.werewolf_minion_charm")}));
        werewolfLord.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)"guide.vampirism.common.minion_control", (Object[])new Object[]{GuideBook.translate((String)ModKeys.MINION.saveString(), (Object[])new Object[0]), GuideBook.translate((String)"text.vampirism.minion.call_single", (Object[])new Object[0]), GuideBook.translate((String)"text.vampirism.minion.respawn", (Object[])new Object[0])})), new Object[0]));
        entries.put(WResourceLocation.mod(base + "lord"), (EntryAbstract)new EntryText(werewolfLord, (Component)GuideBook.translateComponent((String)(base + "lord"), (Object[])new Object[0])));
        ArrayList unWerewolf = new ArrayList();
        unWerewolf.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "un_werewolf.text"), (Object[])new Object[]{WerewolvesGuideBook.loc((Item)ModItems.INJECTION_UN_WEREWOLF.get()), WerewolvesGuideBook.loc((Block)ModBlocks.V.MED_CHAIR.get())})), new Object[]{WResourceLocation.mod("guide.vampirism.items.injection_empty"), WResourceLocation.mod("guide.vampirism.blocks.item_med_chair")}));
        entries.put(WResourceLocation.mod(base + "un_werewolf"), (EntryAbstract)new EntryText(unWerewolf, (Component)GuideBook.translateComponent((String)(base + "un_werewolf"), (Object[])new Object[0])));
        ArrayList creatures = new ArrayList();
        creatures.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent((String)(base + "slayed_creatures.text"), (Object[])new Object[0])), new Object[]{WResourceLocation.mod(base + "leveling")}));
        entries.put(WResourceLocation.mod(base + "slayed_creatures"), (EntryAbstract)new EntryText(creatures, (Component)GuideBook.translateComponent((String)(base + "slayed_creatures"), (Object[])new Object[0])));
        return entries;
    }

    private static void buildItems(Map<ResourceLocation, EntryAbstract> entriesIn, BookHelper helper) {
        LinkedHashMap entries = new LinkedHashMap();
        helper.info(new Item[]{(Item)ModItems.LIVER.get()}).setLinks(new Object[]{WResourceLocation.mod("guide.werewolves.werewolf.leveling")}).build(entries);
        helper.info(new Item[]{(Item)ModItems.CRACKED_BONE.get()}).setLinks(new Object[]{WResourceLocation.mod("guide.werewolves.werewolf.leveling")}).build(entries);
        helper.info(new Item[]{(Item)ModItems.WEREWOLF_MINION_CHARM.get(), (Item)ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE.get(), (Item)ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED.get(), (Item)ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL.get()}).setFormats(new Object[]{WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_CHARM.get()), WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE.get()), ((WerewolfMinionUpgradeItem)((Object)ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE.get())).getMinLevel() + 1, ((WerewolfMinionUpgradeItem)((Object)ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE.get())).getMaxLevel() + 1, WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED.get()), ((WerewolfMinionUpgradeItem)((Object)ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED.get())).getMinLevel() + 1, ((WerewolfMinionUpgradeItem)((Object)ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED.get())).getMaxLevel() + 1, WerewolvesGuideBook.loc((Item)ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL.get()), ((WerewolfMinionUpgradeItem)((Object)ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL.get())).getMinLevel() + 1, ((WerewolfMinionUpgradeItem)((Object)ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL.get())).getMaxLevel() + 1, GuideBook.translate((String)((EntityType)ModEntities.TASK_MASTER_WEREWOLF.get()).getDescriptionId(), (Object[])new Object[0])}).setLinks(new Object[]{WResourceLocation.mod("guide.vampirism.entity.taskmaster"), WResourceLocation.mod("guide.vampirism.vampire.lord")}).build(entries);
        helper.info(new Item[]{(Item)ModItems.WEREWOLF_TOOTH.get()}).setFormats(new Object[]{((WerewolfToothItem)((Object)ModItems.WEREWOLF_TOOTH.get())).getDescription(), ((EntityType)ModEntities.ALPHA_WEREWOLF.get()).getDescription()}).build(entries);
        helper.info(new Item[]{(Item)ModItems.BONE_NECKLACE.get(), (Item)ModItems.CHARM_BRACELET.get(), (Item)ModItems.DREAM_CATCHER.get()}).useCustomEntryName().setKeyName("accessories").build(entries);
        entriesIn.putAll(entries);
    }

    private static void buildBlocks(Map<ResourceLocation, EntryAbstract> entriesIn, BookHelper helper) {
        LinkedHashMap entries = new LinkedHashMap();
        helper.info(new Block[]{(Block)ModBlocks.STONE_ALTAR.get()}).setLinks(new Object[]{WResourceLocation.mod("guide.werewolves.werewolf.leveling")}).recipes(new ResourceLocation[]{WResourceLocation.mod("stone_altar")}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.STONE_ALTAR_FIRE_BOWL.get()}).setLinks(new Object[]{WResourceLocation.mod("guide.werewolves.werewolf.leveling")}).recipes(new ResourceLocation[]{WResourceLocation.mod("stone_altar_fire_bowl")}).build(entries);
        entriesIn.putAll(entries);
    }

    private static Component loc(Item i) {
        return i.getDescription();
    }

    private static Component loc(Block i) {
        return Component.translatable((String)i.getDescriptionId());
    }
}

