/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.mixin.entity;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.werewolves.api.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class MixinVillagerEntity
extends AbstractVillager
implements IVillagerTransformable {
    @Unique
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(Villager.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Unique
    private boolean werewolf;
    @Unique
    private WerewolfForm form = WerewolfForm.BEAST;
    @Unique
    private final EntityActionTier entityTier = EntityActionTier.Medium;
    @Unique
    private EntityClassType entityClass;
    @Unique
    protected int rage;

    @Deprecated
    public MixinVillagerEntity(EntityType<? extends AbstractVillager> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        EntityType type = this.form == WerewolfForm.BEAST ? (EntityType)ModEntities.WEREWOLF_BEAST.get() : (EntityType)ModEntities.WEREWOLF_SURVIVALIST.get();
        BasicWerewolfEntity entity = (BasicWerewolfEntity)WerewolfTransformable.copyData(type, (Mob)this);
        entity.setSourceEntity(this);
        return entity;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        return this;
    }

    @Override
    public boolean canTransform() {
        return this.isWerewolf() && (float)this.rage > this.getMaxHealth() * 4.0f;
    }

    private boolean isWerewolf() {
        return this.werewolf && !(this instanceof IVampire) && ExtendedCreature.getSafe((Entity)this).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false) == false;
    }

    public boolean hurt(@Nonnull DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            if (this.isWerewolf()) {
                this.rage += (int)(amount * 10.0f);
            }
            return true;
        }
        return false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.isWerewolf()) {
            if (this.rage > 150) {
                WerewolfTransformable werewolf = this.transformToWerewolf(TransformType.TIME_LIMITED);
                ((Mob)werewolf).setLastHurtByMob(this.getTarget());
            }
            if (this.level().getGameTime() % 400L == 10L) {
                if (Helper.isFullMoon(this.level())) {
                    this.transformToWerewolf(TransformType.FULL_MOON);
                }
                if (this.rage > 10) {
                    this.rage -= 10;
                }
            }
        }
    }

    @Override
    public void reset() {
        this.rage = 0;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityClass == null ? (this.entityClass = EntityClassType.getRandomClass((RandomSource)this.getRandom())) : this.entityClass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entityTier;
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        int i = (Integer)this.getEntityData().get(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public void setWerewolfFaction(boolean werewolf) {
        this.werewolf = werewolf;
        if (werewolf) {
            this.form = this.getRandom().nextBoolean() ? WerewolfForm.SURVIVALIST : WerewolfForm.BEAST;
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if ((Integer)this.getEntityData().get(TYPE) == -1) {
            this.getEntityData().set(TYPE, (Object)this.getRandom().nextInt(126));
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    protected void werewolves_defineSynchedData(SynchedEntityData.Builder pBuilder, CallbackInfo ci) {
        pBuilder.define(TYPE, (Object)-1);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void werewolves_addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("werewolf", this.werewolf);
        if (this.form != null) {
            nbt.putString("form", this.form.getName());
        }
        nbt.putInt("type", this.getSkinType());
        if (this.entityClass != null) {
            nbt.putInt("entityclasstype", EntityClassType.getID((EntityClassType)this.entityClass));
        }
        compound.put("werewolves", (Tag)nbt);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void werewolves_readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag nbt = compound.getCompound("werewolves");
        this.werewolf = nbt.getBoolean("werewolf");
        if (nbt.contains("form")) {
            this.form = WerewolfForm.getForm(nbt.getString("form"));
        }
        if (nbt.contains("type")) {
            int t = nbt.getInt("type");
            this.getEntityData().set(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.contains("entityclasstype")) {
            this.entityClass = EntityClassType.getEntityClassType((int)nbt.getInt("entityclasstype"));
        }
    }
}

