/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @WrapOperation(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/food/FoodProperties;)V")})
    private void eatWerewolf(FoodData instance, FoodProperties pFoodProperties, Operation<Void> original, Level level, ItemStack stack) {
        Player player = (Player)this;
        if (Helper.isWerewolf(player)) {
            double foodConsumption = player.getAttributeValue(ModAttributes.FOOD_GAIN);
            pFoodProperties = new FoodProperties((int)((double)pFoodProperties.nutrition() * foodConsumption), (float)((double)pFoodProperties.saturation() * foodConsumption), pFoodProperties.canAlwaysEat(), pFoodProperties.eatSeconds(), pFoodProperties.usingConvertsTo(), pFoodProperties.effects());
            WerewolfPlayer werewolf = WerewolfPlayer.get(player);
            if (Helper.isMeat((LivingEntity)player, stack)) {
                if (Helper.isRawMeatSkipMeat(stack)) {
                    pFoodProperties = new FoodProperties(pFoodProperties.nutrition() * 2, pFoodProperties.saturation() * 2.0f, pFoodProperties.canAlwaysEat(), pFoodProperties.eatSeconds(), pFoodProperties.usingConvertsTo(), pFoodProperties.effects());
                }
            } else if (!werewolf.getSkillHandler().isSkillEnabled(ModSkills.NOT_MEAT)) {
                player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.taste_not_right"), true);
                pFoodProperties = new FoodProperties(0, 0.0f, pFoodProperties.canAlwaysEat(), pFoodProperties.eatSeconds(), pFoodProperties.usingConvertsTo(), List.of());
            }
        }
        original.call(new Object[]{instance, pFoodProperties});
    }
}

