/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.items.IWerewolfArmor;
import de.teamlapen.werewolves.client.extensions.ItemExtensions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfPeltArmorItem
extends ArmorItem
implements IFactionExclusiveItem,
IWerewolfArmor,
IItemWithTier {
    @NotNull
    private final IItemWithTier.TIER tier;

    public WolfPeltArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type pType, IItemWithTier.TIER tier) {
        super(material, pType, new Item.Properties());
        this.tier = tier;
    }

    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return WReference.WEREWOLF_FACTION;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ItemExtensions.WOLF_PELT);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return slot == EquipmentSlot.HEAD ? WResourceLocation.mod("textures/models/armor/" + RegUtil.id((Item)this).getPath() + ".png") : super.getArmorTexture(stack, entity, slot, layer, innerModel);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @Nullable Item.TooltipContext pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        this.addTierInformation(pTooltipComponents);
        super.appendHoverText(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public boolean canEquip(@NotNull ItemStack stack, @NotNull EquipmentSlot armorType, @NotNull LivingEntity entity) {
        Player player;
        return super.canEquip(stack, armorType, entity) && Helper.isWerewolf((Entity)entity) && (!(entity instanceof Player) || WerewolfPlayer.get(player = (Player)entity).canWearArmor(stack));
    }

    @Override
    public boolean canWear(IWerewolfPlayer player, WerewolfForm form) {
        return true;
    }
}

