/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities;

import de.teamlapen.vampirism.util.DamageHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;

public class AggressiveWolfEntity
extends Wolf {
    private boolean restrictLiveSpan;
    private boolean dead;
    private int maxTicks;

    public AggressiveWolfEntity(EntityType<? extends AggressiveWolfEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void restrictLiveSpan(int ticks) {
        this.restrictLiveSpan = true;
        this.maxTicks = ticks;
    }

    public boolean canMate(@Nonnull Animal entity) {
        return false;
    }

    public void setOrderedToSit(boolean p_233687_1_) {
    }

    @Nonnull
    protected Component getTypeName() {
        return EntityType.WOLF.getDescription();
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.dead ? null : super.getOwner();
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("restrictLiveSpan", this.restrictLiveSpan);
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.restrictLiveSpan = compound.getBoolean("restrictLiveSpan");
    }

    public void tick() {
        super.tick();
        if (this.restrictLiveSpan && this.tickCount > this.maxTicks) {
            DamageHandler.hurtVanilla((Entity)this, DamageSources::magic, (float)10.0f);
        }
    }

    public void die(@Nonnull DamageSource cause) {
        this.dead = true;
        super.die(cause);
    }
}

