/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.effects.WerewolvesEffect;
import de.teamlapen.werewolves.effects.inst.LupusSanguinemEffectInstance;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class LupusSanguinemEffect
extends WerewolvesEffect {
    public LupusSanguinemEffect() {
        super(MobEffectCategory.HARMFUL, 14684911);
    }

    public static void infectRandomByPlayer(@Nonnull LivingEntity entity) {
        LupusSanguinemEffect.addSanguinemEffectRandom(entity, (Double)WerewolvesConfig.SERVER.playerBiteInfectChance.get());
    }

    public static void infectRandomByMob(@Nonnull LivingEntity entity) {
        LupusSanguinemEffect.addSanguinemEffectRandom(entity, (Double)WerewolvesConfig.SERVER.mobBiteInfectChance.get());
    }

    public static void addSanguinemEffectRandom(@Nonnull LivingEntity entity, double chance) {
        if ((double)entity.getRandom().nextFloat() < chance) {
            LupusSanguinemEffect.addSanguinemEffect(entity);
        }
    }

    public static void addSanguinemEffect(@Nonnull LivingEntity entity) {
        boolean canBecomeWerewolf = false;
        if (entity instanceof Player) {
            canBecomeWerewolf = Helper.canBecomeWerewolf((Player)entity);
        }
        if (canBecomeWerewolf) {
            entity.addEffect((MobEffectInstance)new LupusSanguinemEffectInstance(-1));
        }
    }

    public boolean applyEffectTick(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof Player) {
            FactionPlayerHandler.get((Player)((Player)entityLivingBaseIn)).joinFaction(WReference.WEREWOLF_FACTION);
            return false;
        }
        return true;
    }
}

