/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.lib.lib.data.BaseItemModelGenerator;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ItemModelGenerator
extends BaseItemModelGenerator {
    public ItemModelGenerator(@NotNull PackOutput packOutput, @NotNull ExistingFileHelper existingFileHelper) {
        super(packOutput, "werewolves", existingFileHelper);
    }

    protected void registerModels() {
        HashSet<Supplier<? extends Block>> blockParent = new HashSet<Supplier<? extends Block>>(){
            {
                this.add(ModBlocks.SILVER_ORE);
                this.add(ModBlocks.DEEPSLATE_SILVER_ORE);
                this.add(ModBlocks.SILVER_BLOCK);
                this.add(ModBlocks.RAW_SILVER_BLOCK);
                this.add(ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF);
                this.add(ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF_CRAFTED);
                this.add(ModBlocks.JACARANDA_LOG);
                this.add(ModBlocks.MAGIC_LOG);
                this.add(ModBlocks.STRIPPED_JACARANDA_LOG);
                this.add(ModBlocks.STRIPPED_MAGIC_LOG);
                this.add(ModBlocks.JACARANDA_PLANKS);
                this.add(ModBlocks.MAGIC_PLANKS);
                this.add(ModBlocks.JACARANDA_STAIRS);
                this.add(ModBlocks.MAGIC_STAIRS);
                this.add(ModBlocks.JACARANDA_WOOD);
                this.add(ModBlocks.MAGIC_WOOD);
                this.add(ModBlocks.STRIPPED_JACARANDA_WOOD);
                this.add(ModBlocks.STRIPPED_MAGIC_WOOD);
                this.add(ModBlocks.JACARANDA_PRESSURE_PLATE);
                this.add(ModBlocks.MAGIC_PRESSURE_PLATE);
                this.add(ModBlocks.JACARANDA_SLAB);
                this.add(ModBlocks.MAGIC_SLAB);
                this.add(ModBlocks.JACARANDA_FENCE_GATE);
                this.add(ModBlocks.MAGIC_FENCE_GATE);
                this.add(ModBlocks.JACARANDA_LEAVES);
                this.add(ModBlocks.MAGIC_LEAVES);
            }
        };
        HashSet<Supplier<? extends Item>> itemsLayer = new HashSet<Supplier<? extends Item>>(){
            {
                this.add(ModItems.SILVER_INGOT);
                this.add(ModItems.LIVER);
                this.add(ModItems.CRACKED_BONE);
                this.add(ModItems.INJECTION_UN_WEREWOLF);
                this.add(ModItems.WEREWOLF_TOOTH);
                this.add(ModItems.WEREWOLF_MINION_CHARM);
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE);
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED);
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL);
                this.add(ModItems.SILVER_NUGGET);
                this.add(ModItems.SILVER_HELMET);
                this.add(ModItems.SILVER_CHESTPLATE);
                this.add(ModItems.SILVER_LEGGINGS);
                this.add(ModItems.SILVER_BOOTS);
                this.add(ModItems.WOLF_BERRIES);
                this.add(ModItems.JACARANDA_BOAT);
                this.add(ModItems.MAGIC_BOAT);
                this.add(ModItems.JACARANDA_CHEST_BOAT);
                this.add(ModItems.MAGIC_CHEST_BOAT);
                this.add(ModItems.PELT);
                this.add(ModItems.DARK_PELT);
                this.add(ModItems.WHITE_PELT);
                this.add(ModItems.PELT_HELMET);
                this.add(ModItems.PELT_CHESTPLATE);
                this.add(ModItems.PELT_LEGGINGS);
                this.add(ModItems.PELT_BOOTS);
                this.add(ModItems.DARK_PELT_HELMET);
                this.add(ModItems.DARK_PELT_CHESTPLATE);
                this.add(ModItems.DARK_PELT_LEGGINGS);
                this.add(ModItems.DARK_PELT_BOOTS);
                this.add(ModItems.WHITE_PELT_HELMET);
                this.add(ModItems.WHITE_PELT_CHESTPLATE);
                this.add(ModItems.WHITE_PELT_LEGGINGS);
                this.add(ModItems.WHITE_PELT_BOOTS);
                this.add(ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE);
                this.add(ModItems.WOLFSBANE_FINDER);
            }
        };
        HashSet<Supplier<? extends Block>> blockLayer = new HashSet<Supplier<? extends Block>>(){
            {
                this.add(ModBlocks.WOLFSBANE);
                this.add(ModBlocks.DAFFODIL);
                this.add(ModBlocks.JACARANDA_SAPLING);
                this.add(ModBlocks.MAGIC_SAPLING);
            }
        };
        HashSet<Supplier<? extends Item>> itemsHandHeld = new HashSet<Supplier<? extends Item>>(){
            {
                this.add(ModItems.SILVER_AXE);
                this.add(ModItems.SILVER_PICKAXE);
                this.add(ModItems.SILVER_SWORD);
                this.add(ModItems.SILVER_SHOVEL);
                this.add(ModItems.SILVER_HOE);
            }
        };
        blockParent.stream().map(Supplier::get).forEach(this::block);
        itemsLayer.stream().map(Supplier::get).forEach(arg_0 -> ((ItemModelGenerator)this).item(arg_0));
        blockLayer.stream().map(Supplier::get).forEach(x$0 -> this.blockLayer((Block)x$0, new ResourceLocation[0]));
        itemsHandHeld.stream().map(Supplier::get).forEach(item -> this.item((Item)item, "item/handheld", new ResourceLocation[0]));
        this.withExistingParent((Item)ModItems.WEREWOLF_BEAST_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.WEREWOLF_SURVIVALIST_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.HUMAN_WEREWOLF_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.ALPHA_WEREWOLF_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.item((Item)ModItems.DREAM_CATCHER.get(), this.modLoc("item/dream_catcher_layer0"), this.modLoc("item/dream_catcher_layer1"));
        this.item((Item)ModItems.CHARM_BRACELET.get(), this.modLoc("item/charm_bracelet_layer0"), this.modLoc("item/charm_bracelet_layer1"));
        this.item((Item)ModItems.BONE_NECKLACE.get(), this.modLoc("item/bone_necklace_layer0"), this.modLoc("item/bone_necklace_layer1"));
        this.item((Item)ModItems.RAW_SILVER.get());
        this.withExistingParent((Block)ModBlocks.JACARANDA_TRAPDOOR.get(), this.modLoc("block/jacaranda_trapdoor_bottom"));
        this.withExistingParent((Block)ModBlocks.MAGIC_TRAPDOOR.get(), this.modLoc("block/magic_trapdoor_bottom"));
        this.item(((DoorBlock)ModBlocks.JACARANDA_DOOR.get()).asItem(), this.modLoc("item/jacaranda_door"));
        this.item(((DoorBlock)ModBlocks.MAGIC_DOOR.get()).asItem(), this.modLoc("item/magic_door"));
        this.item((Item)ModItems.JACARANDA_SIGN.get(), this.modLoc("item/jacaranda_sign"));
        this.item((Item)ModItems.MAGIC_SIGN.get(), this.modLoc("item/magic_sign"));
        this.withExistingParent((Block)ModBlocks.JACARANDA_BUTTON.get(), this.mcLoc("block/button_inventory")).texture("texture", this.modLoc("block/jacaranda_planks"));
        this.withExistingParent((Block)ModBlocks.MAGIC_BUTTON.get(), this.mcLoc("block/button_inventory")).texture("texture", this.modLoc("block/magic_planks"));
        this.withExistingParent((Block)ModBlocks.JACARANDA_FENCE.get(), this.mcLoc("block/fence_inventory")).texture("texture", this.modLoc("block/jacaranda_planks"));
        this.withExistingParent((Block)ModBlocks.MAGIC_FENCE.get(), this.mcLoc("block/fence_inventory")).texture("texture", this.modLoc("block/magic_planks"));
        this.block((Block)ModBlocks.WOLFSBANE_DIFFUSER.get(), "wolfsbane_diffuser_normal");
        this.block((Block)ModBlocks.WOLFSBANE_DIFFUSER_IMPROVED.get(), "wolfsbane_diffuser_improved");
        this.block((Block)ModBlocks.WOLFSBANE_DIFFUSER_LONG.get(), "wolfsbane_diffuser_long");
        this.withExistingParent((Item)ModItems.WOLFSBANE_DIFFUSER_CORE.get(), (Item)ModItems.V.GARLIC_DIFFUSER_CORE.get()).texture("texture", "block/wolfsbane_diffuser_inside");
        this.withExistingParent((Item)ModItems.WOLFSBANE_DIFFUSER_CORE_IMPROVED.get(), (Item)ModItems.V.GARLIC_DIFFUSER_CORE.get()).texture("texture", "block/wolfsbane_diffuser_improved_inside");
        this.withExistingParent((Item)ModItems.CROSSBOW_ARROW_SILVER_BOLT.get(), ItemModelGenerator.vLoc("item/crossbow_arrow"));
    }

    protected static ResourceLocation vLoc(String string) {
        return WResourceLocation.v(string);
    }

    @NotNull
    public String getName() {
        return "Werewolves item model generator";
    }

    public ItemModelBuilder item(String item, ResourceLocation ... texture) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated"));
        for (int i = 0; i < texture.length; ++i) {
            model.texture("layer" + i, texture[i]);
        }
        return model;
    }

    public ItemModelBuilder item(@NotNull Item item, ResourceLocation ... texture) {
        return this.item(item, "item/generated", texture);
    }

    public ItemModelBuilder item(@NotNull Item item, String parent, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc(parent)).texture("layer0", "werewolves:item/" + RegUtil.id((Item)item).getPath());
        }
        return this.item(RegUtil.id((Item)item).getPath(), texture);
    }

    public ItemModelBuilder blockLayer(@NotNull Block item, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated")).texture("layer0", "werewolves:block/" + RegUtil.id((Block)item).getPath());
        }
        return this.item(RegUtil.id((Block)item).getPath(), texture);
    }

    @NotNull
    public ItemModelBuilder withExistingParent(@NotNull Item name, ResourceLocation parent) {
        try {
            return (ItemModelBuilder)super.withExistingParent(RegUtil.id((Item)name).getPath(), parent);
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RegUtil.id((Item)name).getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.extendWithFolder(parent)));
        }
    }

    private ResourceLocation extendWithFolder(ResourceLocation rl) {
        if (rl.getPath().contains("/")) {
            return rl;
        }
        return WResourceLocation.loc(rl.getNamespace(), this.folder + "/" + rl.getPath());
    }

    @NotNull
    public ItemModelBuilder withExistingParent(@NotNull Item name, @NotNull Item parent) {
        return this.withExistingParent(name, RegUtil.id((Item)parent));
    }

    @NotNull
    public ItemModelBuilder withExistingParent(@NotNull Block name, ResourceLocation parent) {
        try {
            return (ItemModelBuilder)super.withExistingParent(RegUtil.id((Block)name).getPath(), parent);
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RegUtil.id((Block)name).getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(parent));
        }
    }

    public ItemModelBuilder block(@NotNull Block name) {
        try {
            return (ItemModelBuilder)super.withExistingParent(RegUtil.id((Block)name).getPath(), "werewolves:block/" + RegUtil.id((Block)name).getPath());
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RegUtil.id((Block)name).getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("werewolves:block/" + RegUtil.id((Block)name).getPath()));
        }
    }
}

