/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.werewolves.entities.werewolf.HumanWerewolfEntity;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.PlayerSkin;
import org.jetbrains.annotations.NotNull;

public class HumanWerewolfRenderer
extends DualBipedRenderer<HumanWerewolfEntity, PlayerModel<HumanWerewolfEntity>> {
    private final PlayerSkin[] textures = this.gatherTextures("textures/entity/human", true);

    public HumanWerewolfRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), (HumanoidModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true), 0.5f);
    }

    protected PlayerSkin determineTextureAndModel(HumanWerewolfEntity entity) {
        return this.textures[entity.getSkinType() % this.textures.length];
    }

    protected PlayerSkin @NotNull [] gatherTextures(@NotNull String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.getInstance().getResourceManager().listResources(dirPath, s -> s.getPath().endsWith(".png")).keySet());
        PlayerSkin[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "werewolves".equals(r.getNamespace())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: werewolves:" + dirPath + "/texture.png");
        }
        return textures;
    }
}

