/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import com.mojang.blaze3d.platform.InputConstants;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.werewolves.client.core.ClientEventHandler;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.network.ServerboundBiteEventPackage;
import de.teamlapen.werewolves.network.ServerboundSimpleInputEventPacket;
import de.teamlapen.werewolves.util.Helper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.jetbrains.annotations.ApiStatus;

public class ModKeys {
    private static final String CATEGORY = "keys.werewolves.category";
    private static final String LEAP_KEY = "keys.werewolves.leap";
    private static final String BITE_KEY = "keys.werewolves.bite";
    private static final KeyMapping LEAP = new KeyMapping("keys.werewolves.leap", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 341, "keys.werewolves.category");
    private static final KeyMapping BITE = new KeyMapping("keys.werewolves.bite", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 86, "keys.werewolves.category");
    private final ClientEventHandler clientEventHandler;

    @ApiStatus.Internal
    public static void registerKeyMapping(@Nonnull RegisterKeyMappingsEvent event) {
        event.register(LEAP);
        event.register(BITE);
    }

    public ModKeys(ClientEventHandler clientEventHandler) {
        this.clientEventHandler = clientEventHandler;
    }

    @SubscribeEvent
    public void handleMouseButton(InputEvent.MouseButton.Pre event) {
        this.handleInputEvent((InputEvent)event);
    }

    @SubscribeEvent
    public void handleKey(InputEvent.Key event) {
        this.handleInputEvent((InputEvent)event);
    }

    public void handleInputEvent(InputEvent event) {
        Optional<KeyMapping> keyOpt = this.getPressedKeyBinding();
        keyOpt.ifPresent(key -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (key == LEAP && Minecraft.getInstance().options.keyJump.isDown()) {
                WerewolfPlayer werewolf;
                if (Helper.isWerewolf((Player)player) && !(werewolf = WerewolfPlayer.get((Player)player)).getActionHandler().isActionOnCooldown((IAction)ModActions.LEAP.get()) && werewolf.getForm().isTransformed()) {
                    player.connection.send((CustomPacketPayload)new ServerboundSimpleInputEventPacket(ServerboundSimpleInputEventPacket.Action.LEAP));
                    werewolf.getActionHandler().toggleAction((IAction)ModActions.LEAP.get(), (IAction.ActivationContext)new ActionHandler.ActivationContext());
                }
            } else if (key == BITE && Helper.isWerewolf((Player)player)) {
                Entity entity;
                WerewolfPlayer werewolf = WerewolfPlayer.get((Player)player);
                HitResult mouseOver = Minecraft.getInstance().hitResult;
                Entity entity2 = entity = mouseOver instanceof EntityHitResult ? ((EntityHitResult)mouseOver).getEntity() : null;
                if (entity instanceof LivingEntity && werewolf.canBite() && werewolf.canBiteEntity((LivingEntity)entity)) {
                    player.connection.send((CustomPacketPayload)new ServerboundBiteEventPackage(((EntityHitResult)mouseOver).getEntity().getId()));
                    this.clientEventHandler.onZoomPressed();
                }
            }
        });
    }

    public Optional<KeyMapping> getPressedKeyBinding() {
        if (BITE.consumeClick()) {
            return Optional.of(BITE);
        }
        if (LEAP.isDown()) {
            return Optional.of(LEAP);
        }
        return Optional.empty();
    }
}

