/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.api.items.ISilverItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class ModHUDOverlay {
    private final Minecraft mc = Minecraft.getInstance();
    private final ResourceLocation ICONS = WResourceLocation.mod("textures/gui/hud.png");
    protected static final ResourceLocation WIDGETS_TEX_PATH = WResourceLocation.mc("textures/gui/widgets.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private final List<Integer> entities = new ArrayList<Integer>();
    private int attackTargetScreenPercentage = 0;
    private int waitTicks = 0;

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        if (this.mc.player == null || !this.mc.player.isAlive()) {
            this.screenPercentage = 0;
            this.attackTargetScreenPercentage = 0;
            this.entities.clear();
            this.waitTicks = 0;
            return;
        }
        FactionPlayerHandler.getCurrentFactionPlayer((Player)this.mc.player).filter(WerewolfPlayer.class::isInstance).ifPresentOrElse(player -> this.handleScreenColorWerewolf((WerewolfPlayer)player), () -> {
            this.screenPercentage = 0;
            this.attackTargetScreenPercentage = 0;
            this.waitTicks = 0;
            this.entities.clear();
        });
    }

    @SubscribeEvent
    public void onRenderGui(RenderGuiLayerEvent.Pre event) {
        if (this.mc.player == null || !this.mc.player.isAlive() || event.getName() != VanillaGuiLayers.CROSSHAIR) {
            return;
        }
        this.renderCrosshair(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderWorldLast(RenderGuiEvent.Pre event) {
        int percentages = 0;
        int color = 0;
        if (this.screenPercentage > 0) {
            percentages = this.screenPercentage;
            color = this.screenColor;
        } else if (this.attackTargetScreenPercentage > 0) {
            percentages = this.attackTargetScreenPercentage;
            color = -37369;
        }
        if (percentages > 0 && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            PoseStack stack = event.getGuiGraphics().pose();
            stack.pushPose();
            int w = this.mc.getWindow().getGuiScaledWidth();
            int h = this.mc.getWindow().getGuiScaledHeight();
            int bh = Math.round((float)h / 4.0f * (float)percentages / 100.0f);
            int bw = Math.round((float)w / 8.0f * (float)percentages / 100.0f);
            event.getGuiGraphics().fillGradient(0, 0, w, bh, color, 0);
            if (!OptifineHandler.isShaders()) {
                event.getGuiGraphics().fillGradient(0, h - bh, w, h, 0, color);
            }
            stack.popPose();
        }
    }

    public void attackTriggered(int entityId) {
        if (!this.entities.contains(entityId)) {
            this.entities.add(entityId);
            if (this.waitTicks == 0) {
                this.screenPercentage = 100;
                this.waitTicks = 100;
                this.screenColor = -37369;
            }
        }
    }

    private void handleScreenColorWerewolf(WerewolfPlayer player) {
        boolean sixth_sense = player.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SIXTH_SENSE.get());
        boolean rage = player.getActionHandler().isActionActive((ILastingAction)ModActions.RAGE.get());
        if (sixth_sense) {
            if (this.screenPercentage > 0) {
                this.screenPercentage -= 10;
            }
            if (this.waitTicks > 0) {
                --this.waitTicks;
            }
        } else {
            this.waitTicks = 0;
            this.entities.clear();
        }
        if (rage) {
            this.screenPercentage = 100;
            this.screenColor = -1048576;
        }
        if (!sixth_sense && !rage) {
            this.screenPercentage = 0;
        }
    }

    private void renderFangs(GuiGraphics graphics, int width, int height, @Nullable LivingEntity entity) {
        int left = width / 2 - 9;
        int top = height / 2 - 6;
        boolean silver = false;
        if (entity != null) {
            for (ItemStack stack : entity.getArmorSlots()) {
                if (!(stack.getItem() instanceof ISilverItem)) continue;
                silver = true;
                break;
            }
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(this.ICONS, left, top, silver ? 30.0f : 15.0f, 0.0f, 15, 15, 256, 256);
    }

    private void renderCrosshair(RenderGuiLayerEvent.Pre event) {
        if (((Boolean)WerewolvesConfig.CLIENT.disableFangCrosshairRendering.get()).booleanValue()) {
            return;
        }
        if (Helper.isWerewolf((Player)this.mc.player)) {
            LivingEntity entity;
            LivingEntity living;
            EntityHitResult entityResult;
            Entity entity2;
            HitResult result = Minecraft.getInstance().hitResult;
            LivingEntity livingEntity = result instanceof EntityHitResult ? ((entity2 = (entityResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity ? (living = (LivingEntity)entity2) : null) : (entity = null);
            if (entity != null && WerewolfPlayer.get((Player)this.mc.player).canBite()) {
                this.renderFangs(event.getGuiGraphics(), this.mc.getWindow().getGuiScaledWidth(), this.mc.getWindow().getGuiScaledHeight(), entity);
                event.setCanceled(true);
            }
        }
    }
}

