/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.blocks.entity.WolfsbaneDiffuserBlockEntity;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModTiles;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfsbaneDiffuserBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape shape = WolfsbaneDiffuserBlock.makeShape();
    protected static final MapCodec<WolfsbaneDiffuserBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)StringRepresentable.fromEnum(Type::values).fieldOf("type").forGetter(b -> b.type), (App)WolfsbaneDiffuserBlock.propertiesCodec()).apply((Applicative)inst, WolfsbaneDiffuserBlock::new));
    private final Type type;

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape b = Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        return Shapes.or((VoxelShape)a, (VoxelShape)b);
    }

    public WolfsbaneDiffuserBlock(Type type) {
        this(type, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(40.0f, 1200.0f).sound(SoundType.STONE).noOcclusion());
    }

    public WolfsbaneDiffuserBlock(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void appendHoverText(@NotNull ItemStack pStack, @Nullable Item.TooltipContext context, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        switch (this.type.ordinal()) {
            case 1: 
            case 2: {
                pTooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + "." + this.type.getSerializedName())).withStyle(ChatFormatting.AQUA));
            }
        }
        pTooltip.add((Component)Component.translatable((String)"block.werewolves.wolfsbane_diffuser.tooltip").withStyle(ChatFormatting.GRAY));
        int c = VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist == null ? 1 : 1 + 2 * this.type.range.get();
        pTooltip.add((Component)Component.translatable((String)"block.vampirism.garlic_diffuser.tooltip2", (Object[])new Object[]{c, c}).withStyle(ChatFormatting.GRAY));
    }

    public void attack(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer) {
        WolfsbaneDiffuserBlockEntity tile = this.getTile((BlockGetter)pLevel, pPos);
        if (tile != null) {
            tile.onTouched(pPlayer);
        }
    }

    @NotNull
    public String getDescriptionId() {
        return "block.werewolves.wolfsbane_diffuser";
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return shape;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        WolfsbaneDiffuserBlockEntity tile = new WolfsbaneDiffuserBlockEntity(pPos, pState);
        tile.initiateBootTimer();
        tile.setType(this.type);
        return tile;
    }

    public void playerDestroy(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pBlockEntity, @NotNull ItemStack pTool) {
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
        if (pBlockEntity instanceof WolfsbaneDiffuserBlockEntity) {
            WolfsbaneDiffuserBlockEntity wolfbane = (WolfsbaneDiffuserBlockEntity)pBlockEntity;
            wolfbane.onTouched(pPlayer);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level world, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHitResult) {
        if (!stack.isEmpty() && ModBlocks.WOLFSBANE.asItem() == stack.getItem()) {
            WolfsbaneDiffuserBlockEntity t;
            if (!world.isClientSide && (t = this.getTile((BlockGetter)world, pos)) != null) {
                if (t.getFuelTime() > 0) {
                    player.sendSystemMessage((Component)Component.translatable((String)"block.vampirism.garlic_diffuser.already_fueled"));
                } else {
                    t.onFueled();
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    player.sendSystemMessage((Component)Component.translatable((String)"block.vampirism.garlic_diffuser.successfully_fueled"));
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, pState, world, pos, player, pHand, pHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        WolfsbaneDiffuserBlockEntity t;
        if (world.isClientSide && (t = this.getTile((BlockGetter)world, pos)) != null) {
            WerewolvesMod.proxy.displayWolfsbaneScreen(t, (Component)this.getName());
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    private WolfsbaneDiffuserBlockEntity getTile(@NotNull BlockGetter level, @NotNull BlockPos pos) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof WolfsbaneDiffuserBlockEntity) {
            return (WolfsbaneDiffuserBlockEntity)tile;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return WolfsbaneDiffuserBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.WOLFSBANE_DIFFUSER.get()), WolfsbaneDiffuserBlockEntity::serverTick);
    }

    public static enum Type implements StringRepresentable
    {
        NORMAL("normal", () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserNormalDuration.get() * 20, () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserNormalDist.get(), 1),
        IMPROVED("improved", () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserImprovedDuration.get() * 20, () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserImprovedDist.get(), 2),
        LONG("long", () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserLongDuration.get() * 20, () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserLongDist.get(), 1);

        private final String name;
        public final Supplier<Integer> fuelTime;
        public final Supplier<Integer> range;
        public final int amplifier;

        private Type(String name, Supplier<Integer> fuelTime, Supplier<Integer> range, int amplifier) {
            this.name = name;
            this.fuelTime = fuelTime;
            this.range = range;
            this.amplifier = amplifier;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

