/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.werewolves.blocks.LogBlock;
import de.teamlapen.werewolves.blocks.entity.WolfsbaneDiffuserBlockEntity;
import de.teamlapen.werewolves.client.gui.WerewolfMinionAppearanceScreen;
import de.teamlapen.werewolves.client.gui.WerewolfMinionStatsScreen;
import de.teamlapen.werewolves.client.gui.WolfsbaneDiffuserScreen;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import org.jetbrains.annotations.NotNull;

public class ClientProxy
extends CommonProxy {
    @Override
    public void onInitStep(@NotNull IInitListener.Step step, @NotNull ParallelDispatchEvent event) {
        super.onInitStep(step, event);
        if (step == IInitListener.Step.CLIENT_SETUP) {
            event.enqueueWork(() -> {
                Sheets.addWoodType((WoodType)LogBlock.MAGIC);
                Sheets.addWoodType((WoodType)LogBlock.JACARANDA);
            });
        }
    }

    @Override
    public void displayWolfsbaneScreen(WolfsbaneDiffuserBlockEntity tile, Component title) {
        ClientProxy.openScreen(new WolfsbaneDiffuserScreen(tile, title));
    }

    @Override
    public void displayWerewolfMinionAppearanceScreen(WerewolfMinionEntity entity) {
        ClientProxy.openScreen((Screen)new WerewolfMinionAppearanceScreen(entity, Minecraft.getInstance().screen));
    }

    @Override
    public void displayWerewolfStatsScreen(WerewolfMinionEntity entity) {
        ClientProxy.openScreen((Screen)new WerewolfMinionStatsScreen(entity, Minecraft.getInstance().screen));
    }

    public static void runOnRenderThread(Runnable runnable) {
        Minecraft.getInstance().execute(runnable);
    }

    public static void openScreen(Screen screen) {
        ClientProxy.runOnRenderThread(() -> Minecraft.getInstance().setScreen(screen));
    }
}

