/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.vampirism.world.loot.functions.AddBookNbtFunction;
import de.teamlapen.vampirism.world.loot.functions.RefinementSetFunction;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.blocks.WolfBerryBushBlock;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModLootTables;
import de.teamlapen.werewolves.mixin.VanillaBlockLootAccessor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class LootTablesGenerator {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public static LootTableProvider getProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        return new LootTableProvider(output, ModLootTables.getLootTables(), List.of(new LootTableProvider.SubProviderEntry(ModEntityLootTables::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(ModBlockLootTables::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ChestLootTables::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(EntityInjectLootTables::new, LootContextParamSets.ENTITY)), lookupProvider);
    }

    private record ChestLootTables(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            LootPool.Builder accessories = LootPool.lootPool().name("accessories").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BONE_NECKLACE.get())).setWeight(1).apply((LootItemFunction.Builder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CHARM_BRACELET.get())).setWeight(1).apply((LootItemFunction.Builder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DREAM_CATCHER.get())).setWeight(1).apply((LootItemFunction.Builder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION)));
            consumer.accept(ModLootTables.ABANDONED_MINESHAFT, LootTable.lootTable().withPool(accessories).withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CRACKED_BONE.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10))).withPool(LootPool.lootPool().name("werewolf_pelt_upgrade").when(LootItemRandomChanceCondition.randomChance((float)0.02f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get())))));
            consumer.accept(ModLootTables.DESERT_PYRAMID, LootTable.lootTable().withPool(accessories).withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.LIVER.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10))));
            consumer.accept(ModLootTables.JUNGLE_TEMPLE, LootTable.lootTable().withPool(accessories).withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CRACKED_BONE.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10))).withPool(LootPool.lootPool().name("werewolf_pelt_upgrade").when(LootItemRandomChanceCondition.randomChance((float)0.02f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get())))));
            consumer.accept(ModLootTables.STRONGHOLD_CORRIDOR, LootTable.lootTable().withPool(accessories).withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WEREWOLF_TOOTH.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10))).withPool(LootPool.lootPool().name("werewolf_pelt_upgrade").when(LootItemRandomChanceCondition.randomChance((float)0.02f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get())))));
            consumer.accept(ModLootTables.STRONGHOLD_LIBRARY, LootTable.lootTable().withPool(accessories));
            consumer.accept(ModLootTables.NETHER_BRIDGE, LootTable.lootTable().withPool(LootPool.lootPool().name("werewolf_pelt_upgrade").when(LootItemRandomChanceCondition.randomChance((float)0.05f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get())))));
        }
    }

    private record EntityInjectLootTables(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.VILLAGER, LootTable.lootTable().withPool(LootPool.lootPool().name("liver").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.LIVER.get())).setWeight(1).when(LootItemRandomChanceCondition.randomChance((float)0.5f)))));
            consumer.accept(ModLootTables.SKELETON, LootTable.lootTable().withPool(LootPool.lootPool().name("bones").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CRACKED_BONE.get())).setWeight(1).when(LootItemRandomChanceCondition.randomChance((float)0.1f)))));
            consumer.accept(ModLootTables.HUNTER_LIVER, LootTable.lootTable().withPool(LootPool.lootPool().name("werewolves_general").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.provider, (float)0.33f, (float)0.005f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.LIVER.get())).setWeight(1))));
        }
    }

    private static class ModEntityLootTables
    extends EntityLootSubProvider {
        protected ModEntityLootTables(HolderLookup.Provider provider) {
            super(FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((EntityType)ModEntities.TASK_MASTER_WEREWOLF.get(), LootTable.lootTable());
            this.add((EntityType)ModEntities.WEREWOLF_MINION.get(), LootTable.lootTable());
            LootTable.Builder werewolf = LootTable.lootTable().withPool(LootPool.lootPool().name("general").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.33f, (float)0.05f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.LIVER.get())))).withPool(LootPool.lootPool().name("general2").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.33f, (float)0.05f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CRACKED_BONE.get())).setWeight(40))).withPool(LootPool.lootPool().name("general3").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.33f, (float)0.05f)).setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.PELT.get())).setWeight(40)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DARK_PELT.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(60))).withPool(LootPool.lootPool().name("accessories").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceCondition.randomChance((float)0.05f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.BONE_NECKLACE.get())).setWeight(1).apply((LootItemFunction.Builder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CHARM_BRACELET.get())).setWeight(1).apply((LootItemFunction.Builder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DREAM_CATCHER.get())).setWeight(1).apply((LootItemFunction.Builder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))));
            this.add((EntityType)ModEntities.WEREWOLF_SURVIVALIST.get(), werewolf);
            this.add((EntityType)ModEntities.WEREWOLF_BEAST.get(), werewolf);
            this.add((EntityType)ModEntities.HUMAN_WEREWOLF.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("general").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.33f, (float)0.05f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.LIVER.get())))).withPool(LootPool.lootPool().name("general2").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.33f, (float)0.05f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CRACKED_BONE.get())).setWeight(6))).withPool(LootPool.lootPool().name("hunter").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.1f, (float)0.015f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.V.VAMPIRE_BOOK.get())).setWeight(1))));
            this.add((EntityType)ModEntities.WOLF.get(), LootTable.lootTable());
            this.add((EntityType)ModEntities.ALPHA_WEREWOLF.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("general").when(LootItemKilledByPlayerCondition.killedByPlayer()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WEREWOLF_TOOTH.get()))).setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).withPool(LootPool.lootPool().name("pelt").when(LootItemKilledByPlayerCondition.killedByPlayer()).setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DARK_PELT.get())).setWeight(40)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.WHITE_PELT.get())).setWeight(1))).withPool(LootPool.lootPool().name("vampire_book").when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.1f, (float)0.015f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.V.VAMPIRE_BOOK.get())).apply((LootItemFunction.Builder)AddBookNbtFunction.builder()).setWeight(1))));
        }

        @NotNull
        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ModEntities.getAllEntities().stream();
        }
    }

    private static class ModBlockLootTables
    extends BlockLootSubProvider {
        protected ModBlockLootTables(HolderLookup.Provider provider) {
            super(VanillaBlockLootAccessor.getEXPLOSION_RESISTANT(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            this.add((Block)ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF.get(), LootTable.lootTable());
            this.add((Block)ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF_CRAFTED.get(), this.createSingleItemTable((ItemLike)de.teamlapen.vampirism.core.ModBlocks.TOTEM_TOP.get()));
            this.dropSelf((Block)ModBlocks.WOLFSBANE.get());
            this.dropSelf((Block)ModBlocks.SILVER_BLOCK.get());
            this.dropSelf((Block)ModBlocks.SILVER_ORE.get());
            this.dropSelf((Block)ModBlocks.RAW_SILVER_BLOCK.get());
            this.dropPottedContents((Block)ModBlocks.POTTED_WOLFSBANE.get());
            this.dropSelf((Block)ModBlocks.STONE_ALTAR.get());
            this.dropSelf((Block)ModBlocks.STONE_ALTAR_FIRE_BOWL.get());
            this.add((Block)ModBlocks.SILVER_ORE.get(), block -> this.createOreDrop((Block)block, (Item)ModItems.RAW_SILVER.get()));
            this.add((Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), block -> this.createOreDrop((Block)block, (Item)ModItems.RAW_SILVER.get()));
            this.dropSelf((Block)ModBlocks.DAFFODIL.get());
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.add((Block)ModBlocks.WOLF_BERRY_BUSH.get(), p_249159_ -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)p_249159_, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.WOLF_BERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WolfBerryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModBlocks.WOLF_BERRY_BUSH.asItem())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.WOLF_BERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WolfBerryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModBlocks.WOLF_BERRY_BUSH.asItem())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))))));
            this.dropPottedContents((Block)ModBlocks.POTTED_WOLFSBANE.get());
            this.dropPottedContents((Block)ModBlocks.POTTED_DAFFODIL.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_LOG.get());
            this.dropSelf((Block)ModBlocks.MAGIC_LOG.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_STAIRS.get());
            this.dropSelf((Block)ModBlocks.MAGIC_STAIRS.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_WOOD.get());
            this.dropSelf((Block)ModBlocks.MAGIC_WOOD.get());
            this.dropSelf((Block)ModBlocks.STRIPPED_JACARANDA_WOOD.get());
            this.dropSelf((Block)ModBlocks.STRIPPED_MAGIC_WOOD.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_SIGN.get());
            this.dropSelf((Block)ModBlocks.MAGIC_SIGN.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_WALL_SIGN.get());
            this.dropSelf((Block)ModBlocks.MAGIC_WALL_SIGN.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_PRESSURE_PLATE.get());
            this.dropSelf((Block)ModBlocks.MAGIC_PRESSURE_PLATE.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_BUTTON.get());
            this.dropSelf((Block)ModBlocks.MAGIC_BUTTON.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_SLAB.get());
            this.dropSelf((Block)ModBlocks.MAGIC_SLAB.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_FENCE_GATE.get());
            this.dropSelf((Block)ModBlocks.MAGIC_FENCE_GATE.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_FENCE.get());
            this.dropSelf((Block)ModBlocks.MAGIC_FENCE.get());
            this.dropSelf((Block)ModBlocks.STRIPPED_JACARANDA_LOG.get());
            this.dropSelf((Block)ModBlocks.STRIPPED_MAGIC_LOG.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_PLANKS.get());
            this.dropSelf((Block)ModBlocks.MAGIC_PLANKS.get());
            this.dropSelf((Block)ModBlocks.JACARANDA_TRAPDOOR.get());
            this.dropSelf((Block)ModBlocks.MAGIC_TRAPDOOR.get());
            this.add((Block)ModBlocks.JACARANDA_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)ModBlocks.MAGIC_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)ModBlocks.JACARANDA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)ModBlocks.JACARANDA_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.add((Block)ModBlocks.MAGIC_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)ModBlocks.MAGIC_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Block)ModBlocks.JACARANDA_SAPLING.get());
            this.dropSelf((Block)ModBlocks.MAGIC_SAPLING.get());
            this.dropSelf((Block)ModBlocks.WOLFSBANE_DIFFUSER.get());
            this.dropSelf((Block)ModBlocks.WOLFSBANE_DIFFUSER_LONG.get());
            this.dropSelf((Block)ModBlocks.WOLFSBANE_DIFFUSER_IMPROVED.get());
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.getAllBlocks();
        }
    }
}

