/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.client.gui.screens.VampirismContainerScreen;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.api.client.gui.ScreenAccessor;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.client.WerewolvesModClient;
import de.teamlapen.werewolves.client.gui.ExpBar;
import de.teamlapen.werewolves.client.gui.WerewolfPlayerAppearanceScreen;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.util.TriState;

public class ClientEventHandler {
    private int zoomTime = 0;
    private double zoomAmount = 0.0;
    private double zoomModifier = 0.0;

    @SubscribeEvent
    public void onFOVModifier(ViewportEvent.ComputeFov event) {
        if (this.zoomTime > 0) {
            event.setFOV(event.getFOV() - this.zoomModifier);
            this.zoomModifier -= this.zoomAmount;
            --this.zoomTime;
        }
    }

    @SubscribeEvent
    public void onGuiInitPost(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof VampirismContainerScreen && Helper.isWerewolf((Player)Minecraft.getInstance().player)) {
            WidgetSprites icon = new WidgetSprites(WResourceLocation.v("widget/appearance"), WResourceLocation.v("widget/appearance_highlighted"));
            ImageButton button = ((ScreenAccessor)event.getScreen()).invokeAddRenderableWidget_werewolves(new ImageButton(((VampirismContainerScreen)event.getScreen()).getGuiLeft() + 47, ((VampirismContainerScreen)event.getScreen()).getGuiTop() + 90, 20, 20, icon, context -> Minecraft.getInstance().setScreen((Screen)new WerewolfPlayerAppearanceScreen(event.getScreen())), (Component)Component.empty()));
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.appearance_menu")));
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)Minecraft.getInstance().player);
            if (werewolf.getMaxLevel() == werewolf.getLevel()) {
                return;
            }
            AbstractContainerScreen screen = (AbstractContainerScreen)event.getScreen();
            ((ScreenAccessor)event.getScreen()).invokeAddRenderableWidget_werewolves(new ExpBar(screen.getGuiLeft() - 14, screen.getGuiTop()));
        }
    }

    @SubscribeEvent
    public void onRenderNamePlate(RenderNameTagEvent event) {
        WerewolfPlayer werewolf;
        IActionHandler<IWerewolfPlayer> d;
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity()) && (d = (werewolf = WerewolfPlayer.get((Player)event.getEntity())).getActionHandler()).isActionActive((ILastingAction)ModActions.HIDE_NAME.get()) && FormHelper.isFormActionActive(werewolf)) {
            event.setCanRender(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (Helper.isWerewolf(event.getEntity()) && WerewolvesModClient.getInstance().getModPlayerRenderer().renderPlayer((AbstractClientPlayer)event.getEntity(), 1.0f, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight())) {
            event.setCanceled(true);
        }
    }

    public void onZoomPressed() {
        this.zoomTime = 20;
        this.zoomAmount = (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue() / 4.0f / (float)this.zoomTime;
        this.zoomModifier = (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue() - (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue() / 4.0f;
    }

    @SubscribeEvent
    public void onLevelJoined(ClientPlayerNetworkEvent.LoggingIn event) {
        if (!((Boolean)WerewolvesConfig.CLIENT.mcaMessage.get()).booleanValue() && ModList.get().isLoaded("mca")) {
            WerewolvesConfig.CLIENT.mcaMessage.set((Object)true);
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"text.werewolves.mca_integration.first").append((Component)Component.translatable((String)"text.werewolves.mca_integration.seconds").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/TeamLapen/Werewolves/issues/182")).withUnderlined(Boolean.valueOf(true)))));
        }
    }
}

