/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import com.google.common.base.Preconditions;
import de.teamlapen.werewolves.core.ModAttachments;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class LevelWolfsbane {
    private final HashMap<Integer, Emitter> wolfsbaneEmitter = new HashMap();
    private final HashMap<ChunkPos, Integer> wolfsbaneDiffuser = new HashMap();

    public static Optional<LevelWolfsbane> getOpt(@NotNull Level level) {
        return Optional.of((LevelWolfsbane)level.getData(ModAttachments.LEVEL_WOLFSBANE));
    }

    public int registerWolfsbaneDiffuserBlock(int amplifier, ChunkPos ... chunks) {
        Preconditions.checkArgument((boolean)Arrays.stream(chunks).allMatch(Objects::nonNull), (Object)"Wolfsbane emitter position cannot be null");
        Emitter emitter = new Emitter(amplifier, chunks);
        int hash = emitter.hashCode();
        this.wolfsbaneEmitter.put(hash, emitter);
        this.buildWolfsbaneSet();
        return hash;
    }

    public void removeWolfsbaneBlocksBlock(int id) {
        this.wolfsbaneEmitter.remove(id);
        this.buildWolfsbaneSet();
    }

    private void buildWolfsbaneSet() {
        this.wolfsbaneDiffuser.clear();
        this.wolfsbaneDiffuser.putAll(this.wolfsbaneEmitter.entrySet().stream().flatMap(e -> Arrays.stream(((Emitter)e.getValue()).chunks).map(l -> Pair.of((Object)l, (Object)((Integer)e.getKey())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (a, b) -> a > b ? a : b)));
    }

    public int isEffectedByWolfsbane(BlockPos pos) {
        Integer integer = this.wolfsbaneDiffuser.get(new ChunkPos(pos));
        return integer == null ? -1 : this.wolfsbaneEmitter.get((Object)integer).amplifier;
    }

    private record Emitter(int amplifier, ChunkPos[] chunks) {
    }
}

