/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import de.teamlapen.werewolves.core.ModAttachments;
import de.teamlapen.werewolves.world.ModDamageSources;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;

public class LevelDamage {
    private final ModDamageSources modDamageSources;

    public static Optional<ModDamageSources> getOpt(@NotNull Level level) {
        return Optional.of((LevelDamage)level.getData(ModAttachments.LEVEL_DAMAGE)).map(LevelDamage::getModDamageSources);
    }

    public LevelDamage(Level level) {
        this.modDamageSources = new ModDamageSources(level.registryAccess());
    }

    private ModDamageSources getModDamageSources() {
        return this.modDamageSources;
    }

    public static class Factory
    implements Function<IAttachmentHolder, LevelDamage> {
        @Override
        public LevelDamage apply(IAttachmentHolder holder) {
            if (holder instanceof Level) {
                Level level = (Level)holder;
                return new LevelDamage(level);
            }
            throw new IllegalArgumentException("Cannot create level damage for holder " + holder.getClass() + ". Expected Level");
        }
    }
}

