/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.util;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolfDataholder;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;

public class FormHelper {
    private static final Set<ResourceLocation> noWerewolfFormTickingBiomes = new HashSet<ResourceLocation>();

    public static void reload() {
        noWerewolfFormTickingBiomes.clear();
        List biomes = (List)WerewolvesConfig.SERVER.werewolfFormFreeFormBiomes.get();
        for (String s : biomes) {
            ResourceLocation id = new ResourceLocation(s);
            noWerewolfFormTickingBiomes.add(id);
        }
        noWerewolfFormTickingBiomes.add(ModBiomes.WEREWOLF_FOREST.location());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInWerewolfBiome(LevelAccessor world, BlockPos pos) {
        Holder biome = world.getBiome(pos);
        if (biome.is(ModTags.Biomes.IS_WEREWOLF_BIOME)) return true;
        if (world.getBiome(pos).unwrapKey().map(ResourceKey::location).map(noWerewolfFormTickingBiomes::contains).orElse(false) == false) return false;
        return true;
    }

    public static WerewolfForm getForm(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return WerewolfPlayer.get(player).getForm();
        }
        if (entity instanceof IWerewolfDataholder) {
            IWerewolfDataholder holder = (IWerewolfDataholder)entity;
            return holder.getForm();
        }
        return WerewolfForm.NONE;
    }

    public static boolean isFormActionActive(IWerewolfPlayer player) {
        return WerewolfFormAction.isWerewolfFormActionActive((IActionHandler<IWerewolfPlayer>)player.getActionHandler());
    }

    public static Optional<WerewolfFormAction> getActiveFormAction(IWerewolfPlayer werewolf) {
        return WerewolfFormAction.getAllAction().stream().filter(action -> werewolf.getActionHandler().isActionActive((ILastingAction)action)).findAny();
    }

    public static void deactivateWerewolfActions(IWerewolfPlayer player) {
        WerewolfFormAction.getAllAction().stream().filter(action -> player.getActionHandler().isActionActive((ILastingAction)action)).forEach(action -> player.getActionHandler().toggleAction((IAction)action, (IAction.ActivationContext)new ActionHandler.ActivationContext()));
    }
}

