/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.player.action.IActionCooldownMenu;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public class RageWerewolfAction
extends DefaultWerewolfAction
implements ILastingAction<IWerewolfPlayer>,
IActionCooldownMenu {
    private static final UUID BITE_MODIFIER = UUID.fromString("0ae51804-eaf4-456e-b4ff-24ed326557f4");

    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.rage_enabled.get();
    }

    protected boolean activate(IWerewolfPlayer werewolf, IAction.ActivationContext context) {
        this.applyEffects(werewolf);
        werewolf.asEntity().getAttribute((Attribute)ModAttributes.BITE_DAMAGE.get()).addPermanentModifier(new AttributeModifier(BITE_MODIFIER, "rage_bite_modifier", ((Double)WerewolvesConfig.BALANCE.SKILLS.rage_bite_damage.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        return true;
    }

    public int getDuration(IWerewolfPlayer werewolf) {
        return ((Integer)WerewolvesConfig.BALANCE.SKILLS.rage_duration.get() + (Integer)WerewolvesConfig.BALANCE.SKILLS.rage_duration_level_increase.get() * werewolf.getLevel()) * 20;
    }

    public boolean canBeUsedBy(IWerewolfPlayer player) {
        return player.getForm().isTransformed();
    }

    public void onActivatedClient(IWerewolfPlayer iWerewolfPlayer) {
    }

    public void onDeactivated(IWerewolfPlayer werewolf) {
        this.removePotionEffect(werewolf, MobEffects.DAMAGE_BOOST);
        this.removePotionEffect(werewolf, MobEffects.MOVEMENT_SPEED);
        werewolf.asEntity().getAttribute((Attribute)ModAttributes.BITE_DAMAGE.get()).removeModifier(BITE_MODIFIER);
    }

    public void onReActivated(IWerewolfPlayer iWerewolfPlayer) {
    }

    public boolean onUpdate(IWerewolfPlayer iWerewolfPlayer) {
        if (!iWerewolfPlayer.isRemote() && iWerewolfPlayer.asEntity().tickCount % 20 == 0) {
            this.applyEffects(iWerewolfPlayer);
        }
        return false;
    }

    public int getCooldown(IWerewolfPlayer werewolf) {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.rage_cooldown.get() * 20;
    }

    protected void applyEffects(IWerewolfPlayer werewolf) {
        int speedAmplifier = werewolf.getForm() == WerewolfForm.SURVIVALIST ? 1 : 0;
        int damageAmplifier = werewolf.getForm() == WerewolfForm.BEAST ? 1 : 0;
        this.addEffectInstance(werewolf, new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 22, speedAmplifier, false, false));
        this.addEffectInstance(werewolf, new MobEffectInstance(MobEffects.DAMAGE_BOOST, 22, damageAmplifier, false, false));
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

