/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.client.extensions.EffectExtensions;
import de.teamlapen.werewolves.effects.WerewolvesEffect;
import de.teamlapen.werewolves.util.Helper;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnWerewolfEffect
extends WerewolvesEffect {
    private static final Logger LOGGER = LogManager.getLogger();

    public UnWerewolfEffect() {
        super(MobEffectCategory.NEUTRAL, 14455831);
    }

    public void applyEffectTick(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        Player player;
        if (!entityLivingBaseIn.getCommandSenderWorld().isClientSide() && entityLivingBaseIn instanceof Player && Helper.isWerewolf(player = (Player)entityLivingBaseIn)) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            handler.setFactionAndLevel(null, 0);
            player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.no_longer_werewolf"), true);
            LOGGER.debug("Player {} left faction", (Object)player);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration == 1;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(EffectExtensions.HIDDEN_EFFECT);
    }
}

