/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.vampirism.data.ModBlockFamilies;
import de.teamlapen.werewolves.core.ModRegistries;
import de.teamlapen.werewolves.data.BlockStateGenerator;
import de.teamlapen.werewolves.data.GlobalLootTableGenerator;
import de.teamlapen.werewolves.data.ItemModelGenerator;
import de.teamlapen.werewolves.data.LootTablesGenerator;
import de.teamlapen.werewolves.data.ModTagsProvider;
import de.teamlapen.werewolves.data.RecipeGenerator;
import de.teamlapen.werewolves.data.SkillTreeProvider;
import de.teamlapen.werewolves.mixin.RegistriesDatapackGeneratorAccessor;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod.EventBusSubscriber(modid="werewolves", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = event.getLookupProvider();
        ModBlockFamilies.init();
        DatapackBuiltinEntriesProvider provider = new DatapackBuiltinEntriesProvider(packOutput, (CompletableFuture)lookupProvider, ModRegistries.DATA_BUILDER, Set.of("werewolves"));
        generator.addProvider(event.includeServer(), (DataProvider)provider);
        lookupProvider = ((RegistriesDatapackGeneratorAccessor)provider).getRegistries();
        ModTagsProvider.register(generator, event, packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTablesGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new GlobalLootTableGenerator(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new SkillTreeProvider(packOutput, lookupProvider));
    }

    private static CompletableFuture<HolderLookup.Provider> addVampirismRegistries(CompletableFuture<HolderLookup.Provider> lookupProvider, PackOutput packOutput) {
        DatapackBuiltinEntriesProvider vampirism = new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, de.teamlapen.vampirism.core.ModRegistries.DATA_BUILDER, Set.of("vampirism"));
        return ((RegistriesDatapackGeneratorAccessor)vampirism).getRegistries();
    }
}

