/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.vampirism.advancements.critereon.FactionSubPredicate;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.entity.player.lord.skills.LordSkills;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.SurvivalWerewolfFormAction;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.entities.player.werewolf.skill.DiggerSkill;
import de.teamlapen.werewolves.entities.player.werewolf.skill.FormActionSkill;
import de.teamlapen.werewolves.entities.player.werewolf.skill.SimpleWerewolfSkill;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.SkillUtils;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

public class ModSkills {
    public static final DeferredRegister<ISkill<?>> SKILLS = DeferredRegister.create((ResourceKey)VampirismRegistries.Keys.SKILL, (String)"werewolves");
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> LEVEL_ROOT = SKILLS.register(SkillType.LEVEL.createIdForFaction(REFERENCE.WEREWOLF_PLAYER_KEY).getPath(), () -> new SimpleWerewolfSkill(0, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> LORD_ROOT = SKILLS.register(SkillType.LORD.createIdForFaction(REFERENCE.WEREWOLF_PLAYER_KEY).getPath(), () -> new SimpleWerewolfSkill.LordWerewolfSkill(0, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> HUMAN_FORM = SKILLS.register("human_form", () -> new FormActionSkill((Supplier<WerewolfFormAction>)ModActions.HUMAN_FORM, Trees.LEVEL, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> NIGHT_VISION = SKILLS.register("night_vision", () -> new SimpleWerewolfSkill(true).setToggleActions(player -> {
        ((WerewolfPlayer)player).getSpecialAttributes().night_vision = true;
    }, player -> {
        ((WerewolfPlayer)player).getSpecialAttributes().night_vision = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> RAGE = SKILLS.register("rage", () -> new ActionSkill(ModActions.RAGE, Trees.LEVEL, 2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> BEAST_FORM = SKILLS.register("beast_form", () -> new FormActionSkill((Supplier<WerewolfFormAction>)ModActions.BEAST_FORM, Trees.LEVEL, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> SURVIVAL_FORM = SKILLS.register("survival_form", () -> new FormActionSkill((Supplier<WerewolfFormAction>)ModActions.SURVIVAL_FORM, Trees.LEVEL, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> STUN_BITE = SKILLS.register("stun_bite", () -> {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> BLEEDING_BITE = SKILLS.register("bleeding_bite", () -> {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> DAMAGE = SKILLS.register("damage", () -> {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> RESISTANCE = SKILLS.register("resistance", () -> new SimpleWerewolfSkill(true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> HEALTH_AFTER_KILL = SKILLS.register("health_after_kill", () -> new SimpleWerewolfSkill(1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> HOWLING = SKILLS.register("howling", () -> new ActionSkill(ModActions.HOWLING, Trees.LEVEL, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> SENSE = SKILLS.register("sense", () -> new ActionSkill(ModActions.SENSE, Trees.LEVEL, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> SPEED = SKILLS.register("speed", () -> new SimpleWerewolfSkill.AttributeSkill("speed", true, SkillUtils.SPEED_SKILL, Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADDITION, player -> (Double)WerewolvesConfig.BALANCE.SKILLS.speed_amount.get()));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> JUMP = SKILLS.register("jump", () -> new SimpleWerewolfSkill(true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> LEAP = SKILLS.register("leap", () -> new ActionSkill(ModActions.LEAP, Trees.LEVEL, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> WOLF_PACK = SKILLS.register("wolf_pack", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> HOWLING.get();
        return new SimpleWerewolfSkill(1).defaultDescWithEnhancement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> MOVEMENT_TACTICS = SKILLS.register("movement_tactics", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> THROAT_SEEKER = SKILLS.register("throat_seeker", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> BEAST_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> CLIMBER = SKILLS.register("climber", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray).setToggleActions(SurvivalWerewolfFormAction::climberSkillEnabled, SurvivalWerewolfFormAction::climberSkillDisabled);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> WOLF_PAWN = SKILLS.register("wolf_pawn", () -> new SimpleWerewolfSkill(1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> NOT_MEAT = SKILLS.register("not_meat", () -> new SimpleWerewolfSkill(3, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> WATER_LOVER = SKILLS.register("water_lover", () -> new SimpleWerewolfSkill(true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> FREE_WILL = SKILLS.register("free_will", () -> new SimpleWerewolfSkill(true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> WEAR_ARMOR = SKILLS.register("wear_armor", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> HUMAN_FORM.get();
        return new SimpleWerewolfSkill(3).defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> SILVER_BLOODED = SKILLS.register("silver_blooded", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> HUMAN_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> HIDE_NAME = SKILLS.register("hide_name", () -> new ActionSkill(ModActions.HIDE_NAME, Trees.LEVEL, 1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> FEAR = SKILLS.register("fear", () -> new ActionSkill(ModActions.FEAR, Trees.LEVEL, 1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> SIXTH_SENSE = SKILLS.register("sixth_sense", () -> new SimpleWerewolfSkill(1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> HEALTH_REG = SKILLS.register("health_reg", () -> new SimpleWerewolfSkill(true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> THICK_FUR = SKILLS.register("thick_fur", () -> {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> BEAST_FORM.get();
        supplierArray[1] = () -> SURVIVAL_FORM.get();
        supplierArray[2] = () -> HUMAN_FORM.get();
        return new SimpleWerewolfSkill().defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> DIGGER = SKILLS.register("digger", DiggerSkill::new);
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> ENHANCED_DIGGER = SKILLS.register("enhanced_digger", DiggerSkill::new);
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> MINION_STATS_INCREASE = SKILLS.register("werewolf_minion_stats_increase", () -> new SimpleWerewolfSkill.LordWerewolfSkill(2, true).setToggleActions(IWerewolfPlayer::updateMinionAttributes));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> MINION_COLLECT = SKILLS.register("werewolf_minion_collect", () -> new SimpleWerewolfSkill.LordWerewolfSkill(2, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> BEAST_RAGE = SKILLS.register("beast_rage", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> BEAST_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> ARROW_AWARENESS = SKILLS.register("arrow_awareness", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IWerewolfPlayer>> EFFICIENT_DIET = SKILLS.register("efficient_diet", () -> {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> SURVIVAL_FORM.get();
        return new SimpleWerewolfSkill(true).defaultDescWithFormRequirement(supplierArray);
    });

    @ApiStatus.Internal
    static void register(IEventBus bus) {
        SKILLS.register(bus);
    }

    public static class Trees {
        public static final ResourceKey<ISkillTree> LEVEL = Trees.tree("level");
        public static final ResourceKey<ISkillTree> LORD = Trees.tree("lord");

        private static ResourceKey<ISkillTree> tree(String path) {
            return ResourceKey.create((ResourceKey)VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)new ResourceLocation("werewolves", "werewolf/" + path));
        }

        public static void createSkillTrees(BootstapContext<ISkillTree> context) {
            HolderGetter lookup = context.lookup(VampirismRegistries.Keys.SKILL_NODE);
            context.register(LEVEL, (Object)new SkillTree(WReference.WEREWOLF_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)FactionSubPredicate.faction(WReference.WEREWOLF_FACTION)).build(), new ItemStack((ItemLike)ModItems.LIVER.get()), (Component)Component.translatable((String)"text.vampirism.skills.level")));
            context.register(LORD, (Object)new SkillTree(WReference.WEREWOLF_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)FactionSubPredicate.lord(WReference.WEREWOLF_FACTION)).build(), new ItemStack((ItemLike)ModItems.WEREWOLF_MINION_CHARM.get()), (Component)Component.translatable((String)"text.vampirism.skills.lord")));
        }
    }

    public static class Nodes {
        public static final ResourceKey<ISkillNode> LEVEL_ROOT = Nodes.node("level_root");
        public static final ResourceKey<ISkillNode> SKILL1 = Nodes.node("skill1");
        public static final ResourceKey<ISkillNode> SKILL2 = Nodes.node("skill2");
        public static final ResourceKey<ISkillNode> BEAST1 = Nodes.node("beast1");
        public static final ResourceKey<ISkillNode> BEAST2 = Nodes.node("beast2");
        public static final ResourceKey<ISkillNode> BEAST3_1 = Nodes.node("beast3_1");
        public static final ResourceKey<ISkillNode> BEAST3 = Nodes.node("beast3");
        public static final ResourceKey<ISkillNode> BEAST4 = Nodes.node("beast4");
        public static final ResourceKey<ISkillNode> BEAST5 = Nodes.node("beast5");
        public static final ResourceKey<ISkillNode> BEAST6 = Nodes.node("beast6");
        public static final ResourceKey<ISkillNode> BEAST7 = Nodes.node("beast7");
        public static final ResourceKey<ISkillNode> SURVIVAL1 = Nodes.node("survival1");
        public static final ResourceKey<ISkillNode> SURVIVAL2 = Nodes.node("survival2");
        public static final ResourceKey<ISkillNode> SURVIVAL3 = Nodes.node("survival3");
        public static final ResourceKey<ISkillNode> SURVIVAL4 = Nodes.node("survival4");
        public static final ResourceKey<ISkillNode> SURVIVAL5 = Nodes.node("survival5");
        public static final ResourceKey<ISkillNode> SURVIVAL31 = Nodes.node("survival31");
        public static final ResourceKey<ISkillNode> UTIL1 = Nodes.node("util1");
        public static final ResourceKey<ISkillNode> UTIL2 = Nodes.node("util2");
        public static final ResourceKey<ISkillNode> UTIL3 = Nodes.node("util3");
        public static final ResourceKey<ISkillNode> OTHER1 = Nodes.node("other1");
        public static final ResourceKey<ISkillNode> OTHER2 = Nodes.node("other2");
        public static final ResourceKey<ISkillNode> OTHER3 = Nodes.node("other3");
        public static final ResourceKey<ISkillNode> OTHER4 = Nodes.node("other4");
        public static final ResourceKey<ISkillNode> OTHER5 = Nodes.node("other5");
        public static final ResourceKey<ISkillNode> OTHER6 = Nodes.node("other6");
        public static final ResourceKey<ISkillNode> LORD_ROOT = Nodes.node("lord_root");
        public static final ResourceKey<ISkillNode> LORD_2 = Nodes.node("lord_2");
        public static final ResourceKey<ISkillNode> LORD_3 = Nodes.node("lord_3");
        public static final ResourceKey<ISkillNode> LORD_4 = Nodes.node("lord_4");
        public static final ResourceKey<ISkillNode> LORD_5 = Nodes.node("lord_5");

        private static ResourceKey<ISkillNode> node(String path) {
            return ResourceKey.create((ResourceKey)VampirismRegistries.Keys.SKILL_NODE, (ResourceLocation)new ResourceLocation("werewolves", "werewolf/" + path));
        }

        public static void createSkillNodes(BootstapContext<ISkillNode> context) {
            context.register(LEVEL_ROOT, (Object)new SkillNode(new Holder[]{LEVEL_ROOT}));
            context.register(SKILL1, (Object)new SkillNode(new Holder[]{HUMAN_FORM}));
            context.register(SKILL2, (Object)new SkillNode(new Holder[]{NIGHT_VISION, SENSE}));
            context.register(BEAST1, (Object)new SkillNode(new Holder[]{RAGE}));
            context.register(BEAST2, (Object)new SkillNode(new Holder[]{BEAST_FORM}));
            context.register(BEAST3_1, (Object)new SkillNode(new Holder[]{DAMAGE}));
            context.register(BEAST3, (Object)new SkillNode(new Holder[]{THICK_FUR}));
            context.register(BEAST4, (Object)new SkillNode(new Holder[]{STUN_BITE, BLEEDING_BITE}));
            context.register(BEAST5, (Object)new SkillNode(new Holder[]{HEALTH_AFTER_KILL}));
            context.register(BEAST6, (Object)new SkillNode(new Holder[]{BEAST_RAGE}));
            context.register(BEAST7, (Object)new SkillNode(new Holder[]{FEAR}));
            context.register(SURVIVAL1, (Object)new SkillNode(new Holder[]{JUMP, SPEED}));
            context.register(SURVIVAL2, (Object)new SkillNode(new Holder[]{SURVIVAL_FORM}));
            context.register(SURVIVAL3, (Object)new SkillNode(new Holder[]{WOLF_PAWN, CLIMBER}));
            context.register(SURVIVAL4, (Object)new SkillNode(new Holder[]{EFFICIENT_DIET, ARROW_AWARENESS}));
            context.register(SURVIVAL5, (Object)new SkillNode(new Holder[]{MOVEMENT_TACTICS}));
            context.register(SURVIVAL31, (Object)new SkillNode(new Holder[]{LEAP}));
            context.register(UTIL1, (Object)new SkillNode(new Holder[]{HOWLING}));
            context.register(UTIL2, (Object)new SkillNode(new Holder[]{WOLF_PACK, DIGGER}));
            context.register(UTIL3, (Object)new SkillNode(new Holder[]{NOT_MEAT, HEALTH_REG}));
            context.register(OTHER1, (Object)new SkillNode(new Holder[]{FREE_WILL}));
            context.register(OTHER2, (Object)new SkillNode(new Holder[]{SILVER_BLOODED}));
            context.register(OTHER3, (Object)new SkillNode(new Holder[]{WEAR_ARMOR}));
            context.register(OTHER4, (Object)new SkillNode(new Holder[]{WATER_LOVER}));
            context.register(OTHER5, (Object)new SkillNode(new Holder[]{HIDE_NAME}));
            context.register(OTHER6, (Object)new SkillNode(new Holder[]{ENHANCED_DIGGER}));
            context.register(LORD_ROOT, (Object)new SkillNode(new Holder[]{LORD_ROOT}));
            context.register(LORD_2, (Object)new SkillNode(new Holder[]{MINION_STATS_INCREASE}));
            context.register(LORD_3, (Object)new SkillNode(new Holder[]{LordSkills.LORD_SPEED, LordSkills.LORD_ATTACK_SPEED}));
            context.register(LORD_4, (Object)new SkillNode(new Holder[]{MINION_COLLECT}));
            context.register(LORD_5, (Object)new SkillNode(new Holder[]{LordSkills.MINION_RECOVERY}));
        }
    }
}

