/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.config;

import de.teamlapen.werewolves.config.BalanceConfig;
import de.teamlapen.werewolves.config.ClientConfig;
import de.teamlapen.werewolves.config.CommonConfig;
import de.teamlapen.werewolves.config.ServerConfig;
import de.teamlapen.werewolves.util.FormHelper;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class WerewolvesConfig {
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static final CommonConfig COMMON;
    public static final BalanceConfig BALANCE;
    private static final ModConfigSpec clientSpec;
    private static final ModConfigSpec serverSpec;
    private static final ModConfigSpec commonSpec;
    private static final ModConfigSpec balanceSpec;

    public static void registerConfigs(IEventBus bus) {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)balanceSpec, "werewolves-balance.toml");
        bus.register(WerewolvesConfig.class);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            FormHelper.reload();
        }
    }

    @SubscribeEvent
    public static void onReLoad(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            FormHelper.reload();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(BalanceConfig::new);
        balanceSpec = (ModConfigSpec)specPair.getRight();
        BALANCE = (BalanceConfig)specPair.getLeft();
    }
}

