/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.gui.WerewolfPlayerAppearanceScreen;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public abstract class WerewolfPlayerRenderer<T extends LivingEntity, E extends HumanoidModel<T>>
extends LivingEntityRenderer<T, E> {
    public static Optional<String> getWerewolfRenderer(AbstractClientPlayer player) {
        if (Helper.isWerewolf((Player)player)) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)player);
            WerewolfForm form = werewolf.getForm();
            if (Minecraft.getInstance().screen instanceof WerewolfPlayerAppearanceScreen && ((WerewolfPlayerAppearanceScreen)Minecraft.getInstance().screen).isRenderForm()) {
                form = ((WerewolfPlayerAppearanceScreen)Minecraft.getInstance().screen).getActiveForm();
            }
            if (form == WerewolfForm.BEAST) {
                return Optional.of("werewolves:beast");
            }
            if (form == WerewolfForm.SURVIVALIST) {
                return Optional.of("werewolves:survivalist");
            }
        }
        return Optional.empty();
    }

    public WerewolfPlayerRenderer(EntityRendererProvider.Context context, E model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    public abstract void renderRightHand(PoseStack var1, MultiBufferSource var2, int var3, T var4);

    public abstract void renderLeftHand(PoseStack var1, MultiBufferSource var2, int var3, T var4);

    protected void renderHand(PoseStack stack, MultiBufferSource bufferSource, int p_117778_, T entity, ModelPart arm) {
        HumanoidModel model = (HumanoidModel)this.getModel();
        model.attackTime = 0.0f;
        model.crouching = false;
        model.swimAmount = 0.0f;
        model.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        arm.xRot = 0.0f;
        arm.render(stack, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)this.getTextureLocation((Entity)entity))), p_117778_, OverlayTexture.NO_OVERLAY);
    }

    protected void setupRotations(T pEntityLiving, @NotNull PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        float f = pEntityLiving.getSwimAmount(pPartialTicks);
        if (pEntityLiving.isFallFlying()) {
            super.setupRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        } else if (f > 0.0f) {
            super.setupRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
            this.setupSwimRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        } else {
            super.setupRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        }
    }

    protected abstract void setupSwimRotations(T var1, PoseStack var2, float var3, float var4, float var5);
}

