/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.vampirism.util.PlayerModelType;
import de.teamlapen.werewolves.entities.werewolf.HumanWerewolfEntity;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class HumanWerewolfRenderer
extends DualBipedRenderer<HumanWerewolfEntity, PlayerModel<HumanWerewolfEntity>> {
    private final Pair<ResourceLocation, PlayerModelType>[] textures = this.gatherTextures("textures/entity/human", true);

    public HumanWerewolfRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), (HumanoidModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true), 0.5f);
    }

    protected Pair<ResourceLocation, PlayerModelType> determineTextureAndModel(HumanWerewolfEntity entity) {
        return this.textures[entity.getSkinType() % this.textures.length];
    }

    protected Pair<ResourceLocation, PlayerModelType> @NotNull [] gatherTextures(@NotNull String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.getInstance().getResourceManager().listResources(dirPath, s -> s.getPath().endsWith(".png")).keySet());
        Pair[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "werewolves".equals(r.getNamespace())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: werewolves:" + dirPath + "/texture.png");
        }
        return textures;
    }
}

