/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.werewolves.entities.player.werewolf.LevelHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.MultilineTooltipEx;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ExpBar
extends AbstractWidget {
    private static final ResourceLocation ICON = new ResourceLocation("werewolves", "textures/gui/exp_bar.png");

    public ExpBar(int xIn, int yIn) {
        super(xIn, yIn, 15, 123, (Component)Component.translatable((String)"text.werewolves.skill_screen.level_progression", (Object[])new Object[]{(int)Math.ceil(WerewolfPlayer.get((Player)Minecraft.getInstance().player).getLevelHandler().getLevelPerc() * 100.0f)}));
        this.setTooltip((Tooltip)new MultilineTooltipEx(this.createToolTip()));
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(ICON, this.getX(), this.getY(), 10, 0, this.getWidth(), this.getHeight());
        float perc = WerewolfPlayer.get((Player)Minecraft.getInstance().player).getLevelHandler().getLevelPerc();
        int ySize = (int)(111.0f * perc);
        int color = Optional.ofNullable(VampirismAPI.factionPlayerHandler((Player)Minecraft.getInstance().player).getCurrentFaction()).map(IFaction::getColor).orElse(Color.WHITE.getRGB());
        graphics.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
        graphics.blit(ICON, this.getX() + 5, this.getY() + 6, 0, 0, 5, 111);
        graphics.blit(ICON, this.getX() + 5, this.getY() + 6 + (111 - ySize), 5, 111 - ySize, 5, ySize);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public List<Component> createToolTip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)Component.translatable((String)"text.werewolves.skill_screen.level_progression_label"));
        LevelHandler handler = WerewolfPlayer.get((Player)Minecraft.getInstance().player).getLevelHandler();
        tooltips.add((Component)Component.translatable((String)"text.werewolves.skill_screen.prey_snatched", (Object[])new Object[]{handler.getLevelProgress(), handler.getNeededProgress()}));
        return tooltips;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, this.getMessage());
    }
}

