/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks.entity;

import de.teamlapen.lib.lib.blockentity.InventoryBlockEntity;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.blocks.StoneAltarBlock;
import de.teamlapen.werewolves.blocks.StoneAltarFireBowlBlock;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfLevelConf;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.inventory.container.StoneAltarContainer;
import de.teamlapen.werewolves.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StoneAltarBlockEntity
extends InventoryBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component NAME = Component.translatable((String)"container.werewolves.stone_altar");
    private int targetLevel;
    private Phase phase = Phase.NOT_RUNNING;
    private Player player;
    private UUID playerUuid;
    private int ticks;
    private List<BlockPos> fire_bowls;

    public StoneAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.STONE_ALTAR.get(), pos, state, 2, StoneAltarContainer.SELECTOR_INFOS);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StoneAltarBlockEntity blockEntity) {
        if (level != null && !level.isClientSide) {
            if (blockEntity.playerUuid != null) {
                if (!blockEntity.loadRitual(blockEntity.playerUuid)) {
                    return;
                }
                blockEntity.playerUuid = null;
                blockEntity.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
            }
            switch (blockEntity.phase) {
                case STARTING: {
                    if (blockEntity.ticks != 0) break;
                    blockEntity.phase = Phase.FOG;
                    blockEntity.ticks = 300;
                    blockEntity.setChanged();
                    level.sendBlockUpdated(pos, state, state, 3);
                    break;
                }
                case FOG: {
                    if (blockEntity.ticks == 0) {
                        blockEntity.phase = Phase.ENDING;
                        blockEntity.ticks = 90;
                        blockEntity.player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 3, false, false));
                        blockEntity.setChanged();
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StoneAltarBlock.LIT, (Comparable)Boolean.valueOf(false)));
                        break;
                    }
                    if (blockEntity.ticks % 10 != 0) break;
                    ModParticles.spawnParticlesServer((Level)level, (ParticleOptions)ParticleTypes.MYCELIUM, (double)((double)pos.getX() + Math.random()), (double)(pos.getY() + 1), (double)((double)pos.getZ() + Math.random()), (int)30, (double)0.6, (double)0.6, (double)0.6, (double)0.0);
                    if (blockEntity.fire_bowls == null) break;
                    for (BlockPos fire_bowl : blockEntity.fire_bowls) {
                        ModParticles.spawnParticlesServer((Level)level, (ParticleOptions)ParticleTypes.MYCELIUM, (double)((double)fire_bowl.getX() + Math.random()), (double)(fire_bowl.getY() + 1), (double)((double)fire_bowl.getZ() + Math.random()), (int)30, (double)0.6, (double)0.6, (double)0.6, (double)0.0);
                    }
                    break;
                }
                case ENDING: {
                    if (blockEntity.ticks != 0) break;
                    blockEntity.phase = Phase.NOT_RUNNING;
                    blockEntity.endRitual();
                    blockEntity.cleanup();
                    blockEntity.setChanged();
                    level.sendBlockUpdated(pos, state, state, 3);
                    break;
                }
                case NOT_RUNNING: {
                    return;
                }
            }
            --blockEntity.ticks;
        }
    }

    public void aboardRitual() {
        this.phase = Phase.NOT_RUNNING;
        this.ticks = 0;
        this.cleanup();
    }

    public boolean loadRitual(UUID playerUuid) {
        if (this.level == null) {
            return false;
        }
        if (this.level.players().isEmpty()) {
            return false;
        }
        this.player = this.level.getPlayerByUUID(playerUuid);
        if (this.player == null || !this.player.isAlive()) {
            this.phase = Phase.NOT_RUNNING;
            this.ticks = 0;
            LOGGER.warn("Failed to find player {}", (Object)playerUuid);
            return false;
        }
        this.targetLevel = WerewolfPlayer.get(this.player).getLevel() + 1;
        return true;
    }

    public void startRitual(BlockState state) {
        if (this.player == null) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)StoneAltarBlock.LIT, (Comparable)Boolean.valueOf(false)), 11);
            return;
        }
        if (this.phase == Phase.NOT_RUNNING && ((Boolean)state.getValue((Property)StoneAltarBlock.LIT)).booleanValue()) {
            this.phase = Phase.STARTING;
            this.ticks = 40;
            this.consumeItems();
            this.setChanged();
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void setItem(int slot, @Nonnull ItemStack stack) {
        super.setItem(slot, stack);
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
    }

    public void cleanup() {
        this.targetLevel = 0;
        this.player = null;
    }

    public void endRitual() {
        WerewolfPlayer werewolf = WerewolfPlayer.get(this.player);
        werewolf.getLevelHandler().reset();
        werewolf.syncLevelHandler();
        FactionPlayerHandler handler = FactionPlayerHandler.get((Player)this.player);
        int lvl = handler.getCurrentLevel() + 1;
        handler.setFactionLevel(WReference.WEREWOLF_FACTION, lvl);
    }

    public void consumeItems() {
        WerewolfLevelConf.LevelRequirement requirement = WerewolfLevelConf.getInstance().getRequirement(FactionPlayerHandler.get((Player)this.player).getCurrentLevel() + 1);
        if (requirement instanceof WerewolfLevelConf.StoneAltarRequirement) {
            WerewolfLevelConf.StoneAltarRequirement stoneAltarRequirement = (WerewolfLevelConf.StoneAltarRequirement)requirement;
            this.getItem(0).shrink(stoneAltarRequirement.liverAmount);
            this.getItem(1).shrink(stoneAltarRequirement.bonesAmount);
        }
    }

    public Phase getCurrentPhase() {
        return this.phase;
    }

    public Result canActivate(Player player) {
        if (this.phase != Phase.NOT_RUNNING) {
            return Result.IS_RUNNING;
        }
        if (!Helper.isWerewolf(player)) {
            return Result.OTHER_FACTION;
        }
        this.targetLevel = WerewolfPlayer.get(player).getLevel() + 1;
        if (!this.checkLevel(this.targetLevel)) {
            return Result.WRONG_LEVEL;
        }
        Result r = this.checkStructure();
        if (r != null) {
            return r;
        }
        if (player.getCommandSenderWorld().isDay()) {
            return Result.NIGHT_ONLY;
        }
        if (!this.checkItemRequirements(player)) {
            return Result.INV_MISSING;
        }
        if (!WerewolfPlayer.get(player).getLevelHandler().canLevelUp() && !VampirismMod.inDev) {
            return Result.TO_LESS_BLOOD;
        }
        return Result.OK;
    }

    private Result checkStructure() {
        ArrayList<BlockPos> i = new ArrayList<BlockPos>();
        ArrayList<BlockPos> h = new ArrayList<BlockPos>();
        AABB aabb = new AABB(this.worldPosition).inflate(3.0);
        for (double x = aabb.minX; x <= aabb.maxX; x += 1.0) {
            for (double y = aabb.minY; y <= aabb.maxY; y += 1.0) {
                for (double z = aabb.minZ; z <= aabb.maxZ; z += 1.0) {
                    BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
                    BlockState state = this.level.getBlockState(pos);
                    if (state.getBlock() != ModBlocks.STONE_ALTAR_FIRE_BOWL.get()) continue;
                    i.add(pos);
                    if (!((Boolean)state.getValue((Property)StoneAltarFireBowlBlock.LIT)).booleanValue()) continue;
                    h.add(pos);
                }
            }
        }
        if (h.size() >= 4) {
            this.fire_bowls = h;
            return null;
        }
        if (i.size() >= 4) {
            return Result.STRUCTURE_LIT;
        }
        return Result.STRUCTURE_LESS;
    }

    private boolean checkLevel(int targetLevel) {
        return targetLevel >= 2 && targetLevel <= 14;
    }

    private boolean checkItemRequirements(Player player) {
        WerewolfLevelConf.StoneAltarRequirement req = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(this.targetLevel);
        ItemStack missing = InventoryHelper.checkItems((Container)this, (Item[])new Item[]{(Item)ModItems.LIVER.get(), (Item)ModItems.CRACKED_BONE.get()}, (int[])new int[]{req.liverAmount, req.bonesAmount});
        return missing.isEmpty();
    }

    public Map<Item, Integer> getMissingItems() {
        WerewolfLevelConf.StoneAltarRequirement req = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(this.targetLevel);
        return Helper.getMissingItems((Container)this, new Item[]{(Item)ModItems.LIVER.get(), (Item)ModItems.CRACKED_BONE.get()}, new int[]{req.liverAmount, req.bonesAmount});
    }

    @Nonnull
    protected Component getDefaultName() {
        return NAME;
    }

    @Nonnull
    protected AbstractContainerMenu createMenu(int id, @Nonnull Inventory playerInventory) {
        return new StoneAltarContainer(id, playerInventory, (Container)this, this.level == null ? ContainerLevelAccess.NULL : ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (pkt.getTag() != null) {
            this.load(pkt.getTag());
        }
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void load(@Nonnull CompoundTag tagCompound) {
        super.load(tagCompound);
        if (tagCompound.hasUUID("player")) {
            UUID playerUuid = tagCompound.getUUID("player");
            if (!this.loadRitual(playerUuid)) {
                this.playerUuid = playerUuid;
            }
            this.ticks = tagCompound.getInt("ticks");
            this.phase = Phase.valueOf(tagCompound.getString("phase"));
        }
    }

    public void saveAdditional(CompoundTag compound) {
        if (this.player != null) {
            compound.putUUID("player", this.player.getUUID());
        }
        compound.putInt("ticks", this.ticks);
        compound.putString("phase", this.phase.name());
        super.saveAdditional(compound);
    }

    public static enum Phase {
        NOT_RUNNING,
        STARTING,
        FOG,
        ENDING;

    }

    public static enum Result {
        IS_RUNNING,
        OK,
        WRONG_LEVEL,
        NIGHT_ONLY,
        INV_MISSING,
        OTHER_FACTION,
        STRUCTURE_LESS,
        STRUCTURE_LIT,
        TO_LESS_BLOOD;

    }
}

