/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.werewolves.blocks.entity.StoneAltarBlockEntity;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.util.WUtils;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StoneAltarBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = StoneAltarBlock.makeShape();
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty SOUL_FIRE = WUtils.SOUL_FIRE;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final String REG_NAME = "stone_altar";
    protected static final MapCodec<StoneAltarBlock> CODEC = StoneAltarBlock.simpleCodec(StoneAltarBlock::new);

    public StoneAltarBlock() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 14 : 0));
    }

    public StoneAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.SIGNAL_FIRE, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
        VoxelShape b = Block.box((double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        return Shapes.or((VoxelShape)a, (VoxelShape)b);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            this.dropItems(worldIn, pos);
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean isBurning(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT);
    }

    public boolean placeLiquid(@Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluid) {
        if (super.placeLiquid(world, pos, state, fluid)) {
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
                if (world.isClientSide()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.makeParticles((Level)((Level)world), (BlockPos)pos.above(1), (boolean)false, (boolean)true);
                    }
                } else {
                    ((StoneAltarBlockEntity)world.getBlockEntity(pos)).aboardRitual();
                }
            }
            return true;
        }
        return false;
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state2, boolean p_220082_5_) {
        super.onPlace(state, world, pos, state2, p_220082_5_);
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && state2.getBlock() == this && !((Boolean)state2.getValue((Property)LIT)).booleanValue()) {
            ((StoneAltarBlockEntity)world.getBlockEntity(pos)).startRitual(state);
        }
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public InteractionResult use(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(handIn);
        StoneAltarBlockEntity te = (StoneAltarBlockEntity)worldIn.getBlockEntity(pos);
        if (!worldIn.isClientSide && te != null) {
            StoneAltarBlockEntity.Result result = te.canActivate(player);
            if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                switch (result) {
                    case OTHER_FACTION: {
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.wrong_faction"), true);
                        return InteractionResult.CONSUME;
                    }
                    case IS_RUNNING: {
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.ritual_still_running"), true);
                        return InteractionResult.CONSUME;
                    }
                }
                switch (result) {
                    case NIGHT_ONLY: {
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.ritual_night_only"), true);
                        return InteractionResult.CONSUME;
                    }
                    case WRONG_LEVEL: {
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.ritual_wrong_level"), true);
                        return InteractionResult.CONSUME;
                    }
                    case STRUCTURE_LESS: {
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.ritual_structures_missing"), true);
                        return InteractionResult.CONSUME;
                    }
                    case STRUCTURE_LIT: {
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.ritual_less_lit_structures"), true);
                        return InteractionResult.CONSUME;
                    }
                    case TO_LESS_BLOOD: {
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.ritual_to_less_prey"), true);
                        return InteractionResult.CONSUME;
                    }
                    case INV_MISSING: {
                        Map<Item, Integer> missing = te.getMissingItems();
                        MutableComponent s = Component.translatable((String)"text.werewolves.stone_altar.ritual_missing_items");
                        missing.forEach((item, integer) -> s.append(" ").append((Component)Component.translatable((String)item.getDescriptionId()).withStyle(style -> style.withColor(ChatFormatting.AQUA).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(new ItemStack((ItemLike)item, integer.intValue())))))).append(" " + integer));
                        player.displayClientMessage((Component)s, true);
                        player.openMenu((MenuProvider)te);
                        break;
                    }
                    case OK: {
                        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                            player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.can_not_burn"), true);
                            player.openMenu((MenuProvider)te);
                            return InteractionResult.CONSUME;
                        }
                        te.setPlayer(player);
                        if (heldItem.getItem() == Items.TORCH || heldItem.getItem() == Items.SOUL_TORCH) {
                            worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(heldItem.getItem() == Items.SOUL_TORCH)), 5);
                            return InteractionResult.CONSUME;
                        }
                        if (heldItem.isEmpty()) {
                            player.openMenu((MenuProvider)te);
                            return InteractionResult.CONSUME;
                        }
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.stone_altar.empty_hand"), true);
                        return InteractionResult.PASS;
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ((BlockEntityType)ModTiles.STONE_ALTAR.get()).create(pos, state);
    }

    private void dropItems(Level world, BlockPos pos) {
        Random rand = new Random();
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof Container) {
            Container inventory = (Container)tileEntity;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack item = inventory.getItem(i);
                if (item.isEmpty()) continue;
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.getX() + rx), (double)((float)pos.getY() + ry), (double)((float)pos.getZ() + rz), item.copy());
                if (item.hasTag()) {
                    entityItem.getItem().setTag(item.getTag().copy());
                }
                float factor = 0.05f;
                entityItem.setDeltaMovement(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
                world.addFreshEntity((Entity)entityItem);
                inventory.setItem(i, ItemStack.EMPTY);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT}).add(new Property[]{WATERLOGGED}).add(new Property[]{SOUL_FIRE}).add(new Property[]{HORIZONTAL_FACING}).add(new Property[]{BlockStateProperties.SIGNAL_FIRE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection());
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState rotate(BlockState state, @NotNull LevelAccessor world, @NotNull BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public void animateTick(BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            Vector3f offset = this.getTorchOffset(stateIn);
            worldIn.addParticle((ParticleOptions)((Boolean)stateIn.getValue((Property)SOUL_FIRE) != false ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME), (double)((float)pos.getX() + offset.x()), (double)((float)pos.getY() + offset.y()), (double)((float)pos.getZ() + offset.z()), 0.0, 0.0, 0.0);
        }
    }

    private Vector3f getTorchOffset(BlockState stateIn) {
        Vector3f vec = new Vector3f(0.5f, 0.9625f, 0.5f);
        switch ((Direction)stateIn.getValue((Property)HORIZONTAL_FACING)) {
            case EAST: {
                vec.add((Vector3fc)new Vector3f(0.28125f, 0.0f, 0.28125f));
                break;
            }
            case SOUTH: {
                vec.add((Vector3fc)new Vector3f(-0.28125f, 0.0f, 0.28125f));
                break;
            }
            case WEST: {
                vec.add((Vector3fc)new Vector3f(-0.28125f, 0.0f, -0.28125f));
                break;
            }
            default: {
                vec.add((Vector3fc)new Vector3f(0.28125f, 0.0f, -0.28125f));
            }
        }
        return vec;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return StoneAltarBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.STONE_ALTAR.get()), StoneAltarBlockEntity::tick);
    }
}

