/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MobLootModifier
extends LootModifier {
    private static final Codec<LootTable> LOOT_TABLE_CODEC = LootTable.CODEC;
    public static final Codec<MobLootModifier> CODEC = RecordCodecBuilder.create(inst -> MobLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)LOOT_TABLE_CODEC.fieldOf("lootTable").forGetter(a -> a.lootTable)).apply((Applicative)inst, MobLootModifier::new));
    private final LootTable lootTable;

    @NotNull
    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public MobLootModifier(LootItemCondition[] conditionsIn, LootTable lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        this.lootTable.getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> generatedLoot.add(arg_0)));
        return generatedLoot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LootTable lootTable;
        private final List<EntityType<?>> entityTypes = new ArrayList();

        public Builder table(LootTable.Builder table) {
            this.lootTable = table.build();
            return this;
        }

        public Builder onlyFor(EntityType<?> ... types) {
            return this.onlyFor(Arrays.asList(types));
        }

        public Builder onlyFor(List<EntityType<?>> types) {
            this.entityTypes.addAll(types);
            return this;
        }

        public MobLootModifier build() {
            if (this.entityTypes.isEmpty()) {
                throw new IllegalStateException("You must specify target entities");
            }
            return new MobLootModifier(new LootItemCondition[]{this.entityTypes.stream().map(type -> LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(type))).collect(() -> new AnyOfCondition.Builder(new LootItemCondition.Builder[0]), AnyOfCondition.Builder::or, AnyOfCondition.Builder::or).build()}, this.lootTable);
        }
    }
}

