/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.mixin;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={FoodData.class})
public class FoodDataMixin {
    @ModifyVariable(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private FoodProperties eat(FoodProperties value, Item pItem, ItemStack pStack, @Nullable LivingEntity entity) {
        Player player;
        FoodProperties returnValue = value;
        if (entity instanceof Player && Helper.isWerewolf(player = (Player)entity)) {
            float foodConsumption = (float)player.getAttributeValue((Attribute)ModAttributes.FOOD_GAIN.get());
            if (Helper.isMeat((LivingEntity)player, pStack)) {
                returnValue = Helper.isRawMeatSkipMeat(pStack) ? this.werewolves$builder(value).saturationMod(value.getSaturationModifier() * 2.0f * foodConsumption).nutrition((int)((float)(value.getNutrition() * 2) * foodConsumption)).build() : this.werewolves$builder(value).saturationMod(value.getSaturationModifier() * foodConsumption).nutrition((int)((float)value.getNutrition() * foodConsumption)).build();
            } else if (!WerewolfPlayer.get(player).getSkillHandler().isSkillEnabled((ISkill)ModSkills.NOT_MEAT.get())) {
                player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.taste_not_right"), true);
                returnValue = this.werewolves$builder(value).saturationMod(0.0f).nutrition(0).build();
            } else {
                returnValue = this.werewolves$builder(value).saturationMod(value.getSaturationModifier() * foodConsumption).nutrition((int)((float)value.getNutrition() * foodConsumption)).build();
            }
        }
        return returnValue;
    }

    @Unique
    private FoodProperties.Builder werewolves$builder(FoodProperties properties) {
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(properties.getNutrition()).saturationMod(properties.getSaturationModifier());
        if (properties.isMeat()) {
            builder.meat();
        }
        if (properties.isFastFood()) {
            builder.fast();
        }
        if (properties.canAlwaysEat()) {
            builder.alwaysEat();
        }
        properties.getEffects().forEach(effect -> builder.effect(() -> ((Pair)effect).getFirst(), ((Float)effect.getSecond()).floatValue()));
        return builder;
    }
}

