/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import de.teamlapen.lib.lib.storage.ISyncableSaveData;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WerewolfInventory
implements ISyncableSaveData {
    private static final String KEY_INVENTORY = "inventory";
    private final WerewolfPlayer werewolf;
    private final Map<WerewolfForm, List<ItemStack>> inventories;
    private WerewolfForm form = WerewolfForm.NONE;

    public WerewolfInventory(WerewolfPlayer werewolf) {
        this.werewolf = werewolf;
        HashMap<WerewolfForm, List<ItemStack>> inventories = new HashMap<WerewolfForm, List<ItemStack>>();
        WerewolfForm.getAllForms().forEach(form -> inventories.put((WerewolfForm)form, (List<ItemStack>)NonNullList.withSize((int)4, (Object)ItemStack.EMPTY)));
        this.inventories = inventories;
    }

    public void swapArmorItems(WerewolfForm to) {
        boolean armor = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WEAR_ARMOR.get()) && to != WerewolfForm.NONE && to.isHumanLike();
        NonNullList previousArmor = this.werewolf.getRepresentingPlayer().getInventory().armor;
        this.inventories.put(this.form, new ArrayList(previousArmor));
        previousArmor.clear();
        List<ItemStack> itemStacks = this.inventories.get(to);
        if (armor && itemStacks.stream().allMatch(ItemStack::isEmpty)) {
            to = WerewolfForm.NONE;
            itemStacks = this.inventories.get(to);
        }
        for (int i = 0; i < 4; ++i) {
            previousArmor.set(i, itemStacks.get(i));
        }
        this.inventories.put(to, (List<ItemStack>)previousArmor);
        this.form = to;
    }

    public void dropEquipment() {
        Player player = this.werewolf.getRepresentingPlayer();
        for (List<ItemStack> list : this.inventories.values()) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i);
                if (stack.isEmpty()) continue;
                player.drop(stack, true, false);
                list.set(i, ItemStack.EMPTY);
            }
        }
    }

    public void dropFormEquipment(WerewolfForm form) {
        Player player = this.werewolf.getRepresentingPlayer();
        List<ItemStack> list = this.inventories.get(form);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            if (stack.isEmpty()) continue;
            if (!player.addItem(stack)) {
                player.drop(stack, false);
            }
            list.set(i, ItemStack.EMPTY);
        }
    }

    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("lastForm", this.form.getName());
        CompoundTag tag = new CompoundTag();
        nbt.put(KEY_INVENTORY, (Tag)tag);
        this.inventories.forEach((form, armor) -> {
            ListTag list = new ListTag();
            for (int i = 0; i < armor.size(); ++i) {
                ItemStack stack = (ItemStack)armor.get(i);
                if (stack.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putByte("Slot", (byte)i);
                stack.save(itemTag);
                list.add((Object)itemTag);
            }
            tag.put(form.getName(), (Tag)list);
        });
        return nbt;
    }

    public void deserializeNBT(@NotNull CompoundTag compoundTag) {
        this.form = Objects.requireNonNullElse(WerewolfForm.getForm(compoundTag.getString("lastForm")), WerewolfForm.NONE);
        CompoundTag inventory = compoundTag.getCompound(KEY_INVENTORY);
        inventory.getAllKeys().stream().map(WerewolfForm::getForm).forEach(form -> {
            ListTag list = inventory.getList(form.getName(), 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.getCompound(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                ItemStack stack = ItemStack.of((CompoundTag)itemTag);
                this.inventories.get(form).set(slot, stack);
            }
        });
    }

    public void deserializeUpdateNBT(@NotNull CompoundTag compoundTag) {
        this.deserializeNBT(compoundTag);
    }

    @NotNull
    public CompoundTag serializeUpdateNBT() {
        return this.serializeNBT();
    }

    public String nbtKey() {
        return KEY_INVENTORY;
    }
}

