/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.core.ModMinionTasks;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.items.WerewolfMinionUpgradeItem;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WerewolfMinionEntity
extends MinionEntity<WerewolfMinionData>
implements IWerewolf {
    public static AttributeSupplier.Builder getAttributeBuilder() {
        return BasicWerewolfEntity.getAttributeBuilder();
    }

    public WerewolfMinionEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(WReference.WEREWOLF_FACTION, true, true, false, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof Enemy && !(e instanceof Creeper)));
    }

    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{(IMinionTask)ModMinionTasks.V.FOLLOW_LORD.get(), (IMinionTask)ModMinionTasks.V.DEFEND_AREA.get(), (IMinionTask)ModMinionTasks.V.STAY.get(), (IMinionTask)ModMinionTasks.V.PROTECT_LORD.get(), (IMinionTask)ModMinionTasks.COLLECT_WEREWOLF_ITEMS.get()});
    }

    public boolean shouldRenderLordSkin() {
        return false;
    }

    public void openAppearanceScreen() {
        WerewolvesMod.proxy.displayWerewolfMinionAppearanceScreen(this);
    }

    public void openStatsScreen() {
        WerewolvesMod.proxy.displayWerewolfStatsScreen(this);
    }

    protected boolean canConsume(@NotNull ItemStack stack) {
        if (!super.canConsume(stack)) {
            return false;
        }
        if (stack.isEdible() && !Helper.isMeat((LivingEntity)this, stack)) {
            return false;
        }
        boolean fullHealth = this.getHealth() == this.getMaxHealth();
        return !fullHealth || !stack.isEdible();
    }

    @Nonnull
    public ItemStack eat(@Nonnull Level world, @Nonnull ItemStack stack) {
        if (stack.isEdible() && Helper.isRawMeat((LivingEntity)this, stack)) {
            float healAmount = (float)stack.getFoodProperties((LivingEntity)this).getNutrition() / 2.0f;
            this.heal(healAmount);
        }
        return super.eat(world, stack);
    }

    protected void onMinionDataReceived(@Nonnull WerewolfMinionData data) {
        super.onMinionDataReceived((MinionData)data);
        this.updateAttributes();
    }

    @NotNull
    public Predicate<ItemStack> getEquipmentPredicate(EquipmentSlot slotType) {
        return itemStack -> itemStack.getItem() instanceof IFactionExclusiveItem && ((IFactionExclusiveItem)itemStack.getItem()).getExclusiveFaction(itemStack).equals(WReference.WEREWOLF_FACTION) || itemStack.getUseAnimation() == UseAnim.DRINK || itemStack.getUseAnimation() == UseAnim.EAT;
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack heldItem;
        if (!this.level().isClientSide() && this.isLord(player) && this.minionData != null && (heldItem = player.getItemInHand(hand)).getItem() instanceof WerewolfMinionUpgradeItem && ((WerewolfMinionUpgradeItem)heldItem.getItem()).getFaction() == this.getFaction()) {
            if (((WerewolfMinionData)this.minionData).level + 1 >= ((WerewolfMinionUpgradeItem)heldItem.getItem()).getMinLevel() && ((WerewolfMinionData)this.minionData).level + 1 <= ((WerewolfMinionUpgradeItem)heldItem.getItem()).getMaxLevel()) {
                ++((WerewolfMinionData)this.minionData).level;
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.werewolf_minion.equipment_upgrade"), false);
                HelperLib.sync((Entity)this);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.werewolf_minion.equipment_wrong"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).form : WerewolfForm.NONE;
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).skinType : 0;
    }

    @Override
    public int getEyeType(WerewolfForm form) {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).eyeType : 0;
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return this.minionData != null && ((WerewolfMinionData)this.minionData).glowingEyes;
    }

    private void updateAttributes() {
        float statsMultiplier = this.getMinionData().filter(d -> d.hasIncreasedStats).map(a -> Float.valueOf(1.2f)).orElse(Float.valueOf(1.0f)).floatValue();
        AttributeInstance attributeInstance = this.getAttribute(Attributes.MAX_HEALTH);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.setBaseValue((45.0 + 5.0 * (double)this.getMinionData().map(WerewolfMinionData::getHealthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        AttributeInstance attributeInstance2 = this.getAttribute(Attributes.ATTACK_DAMAGE);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.setBaseValue((3.0 + 1.0 * (double)this.getMinionData().map(WerewolfMinionData::getStrengthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        AttributeInstance attributeInstance3 = this.getAttribute(Attributes.MOVEMENT_SPEED);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance3.setBaseValue(0.28 * (double)statsMultiplier);
    }

    public void setEyeType(int type) {
        this.getMinionData().ifPresent(d -> {
            d.eyeType = type;
        });
    }

    public void setSkinType(int type) {
        this.getMinionData().ifPresent(d -> {
            d.skinType = type;
        });
    }

    public void setGlowingEyes(boolean glowing) {
        this.getMinionData().ifPresent(d -> {
            d.glowingEyes = glowing;
        });
    }

    public static class WerewolfMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("werewolves", "werewolf");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_RESOURCES = 2;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int resourceEfficiencyLevel;
        private int skinType;
        private int eyeType;
        private boolean glowingEyes;
        private WerewolfForm form = WerewolfForm.BEAST;
        private boolean hasIncreasedStats;

        public WerewolfMinionData(String name, int skinType, int eyeType, boolean glowingEyes, WerewolfForm form, boolean hasIncreasedStats) {
            super(name, 9);
            this.hasIncreasedStats = hasIncreasedStats;
            assert (!form.isHumanLike());
            this.level = 0;
            this.skinType = skinType;
            this.eyeType = eyeType;
            this.glowingEyes = glowingEyes;
            this.form = form;
        }

        public WerewolfMinionData() {
        }

        public MutableComponent getFormattedName() {
            return super.getFormattedName().withStyle(style -> style.withColor(WReference.WEREWOLF_FACTION.getChatColor()));
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        public int getLevel() {
            return this.level;
        }

        public int getSkinType() {
            return this.skinType;
        }

        public int getEyeType() {
            return this.eyeType;
        }

        public boolean hasGlowingEyes() {
            return this.glowingEyes;
        }

        public int getResourceEfficiencyLevel() {
            return this.resourceEfficiencyLevel;
        }

        public WerewolfForm getForm() {
            return this.form;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.strengthLevel - this.resourceEfficiencyLevel);
        }

        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.resourceEfficiencyLevel > 0;
        }

        public void resetStats(@NotNull MinionEntity<?> entity) {
            this.inventoryLevel = 0;
            this.strengthLevel = 0;
            this.healthLevel = 0;
            this.resourceEfficiencyLevel = 0;
            this.shrinkInventory(entity);
            super.resetStats(entity);
        }

        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public void handleMinionAppearanceConfig(String name, int ... data) {
            this.setName(name);
            this.skinType = data[0];
            this.eyeType = data[1];
            this.glowingEyes = data[2] == 1;
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        public boolean upgradeStat(int statId, @NotNull MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof WerewolfMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    entity.setHealth(entity.getMaxHealth());
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.resourceEfficiencyLevel >= 2) {
                        return false;
                    }
                    ++this.resourceEfficiencyLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        public void deserializeNBT(@NotNull CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.level = nbt.getInt("level");
            this.inventoryLevel = nbt.getInt("l_inv");
            this.healthLevel = nbt.getInt("l_he");
            this.strengthLevel = nbt.getInt("l_str");
            this.resourceEfficiencyLevel = nbt.getInt("l_res");
            this.skinType = nbt.getInt("s_type");
            this.eyeType = nbt.getInt("e_type");
            this.glowingEyes = nbt.getBoolean("e_glow");
            this.form = WerewolfForm.getForm(nbt.getString("form"));
            this.hasIncreasedStats = nbt.getBoolean("hasIncreasedStats");
        }

        public void serializeNBT(@NotNull CompoundTag tag) {
            super.serializeNBT(tag);
            tag.putInt("level", this.level);
            tag.putInt("l_inv", this.inventoryLevel);
            tag.putInt("l_he", this.healthLevel);
            tag.putInt("l_str", this.strengthLevel);
            tag.putInt("l_res", this.resourceEfficiencyLevel);
            tag.putInt("s_type", this.skinType);
            tag.putInt("e_type", this.eyeType);
            tag.putBoolean("e_glow", this.glowingEyes);
            tag.putString("form", this.form.getName());
            tag.putBoolean("hasIncreasedStats", this.hasIncreasedStats);
        }

        protected ResourceLocation getDataType() {
            return ID;
        }

        public void setIncreasedStats(boolean hasIncreasedStats) {
            this.hasIncreasedStats = hasIncreasedStats;
        }

        public void setSkinType(int skinType) {
            this.skinType = skinType;
        }

        public void setEyeType(int eyeType) {
            this.eyeType = eyeType;
        }

        public void setGlowingEyes(boolean glowingEyes) {
            this.glowingEyes = glowingEyes;
        }

        public void setForm(WerewolfForm form) {
            this.form = form;
        }
    }
}

