/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.effects.WerewolvesEffect;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WerewolfWeakeningEffect
extends WerewolvesEffect {
    private final List<Modifier> modifiers;

    protected WerewolfWeakeningEffect(int color, List<Modifier> attributes) {
        super(MobEffectCategory.HARMFUL, color);
        this.modifiers = attributes;
    }

    public void applyEffectTick(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        if (!Helper.isWerewolf((Entity)entityLivingBaseIn)) {
            entityLivingBaseIn.removeEffect((MobEffect)this);
        }
    }

    public void onEffectStarted(@NotNull LivingEntity entity, int amplifier) {
        if (!Helper.isWerewolf((Entity)entity)) {
            entity.removeEffect((MobEffect)this);
        } else {
            this.addAttributeModifiers(entity, entity.getAttributes(), amplifier);
        }
    }

    public void addAttributeModifiers(@NotNull AttributeMap attributeMap, int amplifier) {
    }

    public void addAttributeModifiers(LivingEntity livingEntity, @NotNull AttributeMap attributeMap, int pAmplifier) {
        for (Map.Entry<Attribute, AttributeModifierTemplate> entry : this.getAttributeModifiers(livingEntity).entrySet()) {
            AttributeInstance attributeinstance = attributeMap.getInstance(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.removeModifier(entry.getValue().getAttributeModifierId());
            attributeinstance.addPermanentModifier(entry.getValue().create(pAmplifier));
        }
    }

    public void removeAttributeModifiers(@NotNull AttributeMap attributeMap) {
        for (Map.Entry<Attribute, UUID> entry : this.getAttributes().entrySet()) {
            AttributeInstance attributeinstance = attributeMap.getInstance(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.removeModifier(entry.getValue());
        }
    }

    public Map<Attribute, UUID> getAttributes() {
        HashMap<Attribute, UUID> map = new HashMap<Attribute, UUID>();
        this.modifiers.forEach(modifier -> map.put(modifier.attribute(), modifier.uuid()));
        return map;
    }

    @NotNull
    public Map<Attribute, AttributeModifierTemplate> getAttributeModifiers(@Nullable LivingEntity entity) {
        HashMap<Attribute, AttributeModifierTemplate> map = new HashMap<Attribute, AttributeModifierTemplate>();
        if (entity == null || Helper.isWerewolf((Entity)entity)) {
            IWerewolf werewolf;
            int maxLevel;
            int level;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                WerewolfPlayer werewolf2 = WerewolfPlayer.get(player);
                level = werewolf2.getLevel();
                maxLevel = werewolf2.getMaxLevel();
            } else if (entity instanceof IWerewolf && (werewolf = (IWerewolf)entity) instanceof IAdjustableLevel) {
                IAdjustableLevel levelEntity = (IAdjustableLevel)werewolf;
                level = levelEntity.getEntityLevel();
                maxLevel = levelEntity.getMaxEntityLevel();
            } else {
                level = 1;
                maxLevel = 1;
            }
            this.modifiers.forEach(modifier -> map.put(modifier.attribute, modifier.createModifier(level, maxLevel)));
        }
        return map;
    }

    protected record Modifier(Attribute attribute, UUID uuid, String name, float maxModifier, int startingAmplifier) {
        Modifier(Attribute attribute, UUID uuid, String name, float maxModifier) {
            this(attribute, uuid, name, maxModifier, 0);
        }

        public AttributeModifierTemplate createModifier(int level, int maxLevel) {
            final double value = LevelAttributeModifier.calculateModifierValue((int)level, (int)maxLevel, (double)this.maxModifier, (double)1.3);
            return new AttributeModifierTemplate(){

                @NotNull
                public UUID getAttributeModifierId() {
                    return uuid;
                }

                @NotNull
                public AttributeModifier create(int pAmplifier) {
                    ++pAmplifier;
                    pAmplifier = Math.max(0, pAmplifier - startingAmplifier);
                    return new AttributeModifier(this.uuid(), this.name(), (double)(-pAmplifier) * value, AttributeModifier.Operation.MULTIPLY_TOTAL);
                }
            };
        }
    }
}

