/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModTags;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModTags {

    public static class Entities {
        public static final TagKey<EntityType<?>> WEREWOLF = Entities.tag("werewolf");

        @NotNull
        private static TagKey<EntityType<?>> tag(@NotNull ResourceLocation resourceLocation) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)resourceLocation);
        }

        @NotNull
        private static TagKey<EntityType<?>> tag(@NotNull String name) {
            return Entities.tag(new ResourceLocation("werewolves", name));
        }
    }

    public static class Tasks {
        public static final TagKey<Task> IS_WEREWOLF = Tasks.tag("is_werewolf");
        public static final TagKey<Task> AWARDS_LORD_LEVEL = Tasks.vampirism("awards_lord_level");
        public static final TagKey<Task> HAS_FACTION = Tasks.vampirism("has_faction");

        @NotNull
        private static TagKey<Task> tag(@NotNull String name) {
            return TagKey.create((ResourceKey)VampirismRegistries.Keys.TASK, (ResourceLocation)new ResourceLocation("werewolves", name));
        }

        @NotNull
        private static TagKey<Task> vampirism(@NotNull String name) {
            return TagKey.create((ResourceKey)VampirismRegistries.Keys.TASK, (ResourceLocation)new ResourceLocation("vampirism", name));
        }
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> WEREWOLF_FUR_IMMUNE = DamageTypes.tag("werewolf_fur_immune");

        @NotNull
        private static TagKey<DamageType> tag(@NotNull String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("werewolves", name));
        }
    }

    public static class Professions {
        public static final TagKey<VillagerProfession> IS_WEREWOLF = Professions.tag("is_werewolf");

        @NotNull
        private static TagKey<VillagerProfession> tag(@NotNull String name) {
            return TagKey.create((ResourceKey)Registries.VILLAGER_PROFESSION, (ResourceLocation)new ResourceLocation("werewolves", name));
        }
    }

    public static class PoiTypes {
        public static final TagKey<PoiType> IS_WEREWOLF = PoiTypes.tag("is_werewolf");
        public static final TagKey<PoiType> HAS_FACTION = PoiTypes.vampirism("has_faction");

        @NotNull
        private static TagKey<PoiType> tag(@NotNull String name) {
            return PoiTypes.tag("werewolves", name);
        }

        @NotNull
        private static TagKey<PoiType> vampirism(@NotNull String name) {
            return PoiTypes.tag("vampirism", name);
        }

        @NotNull
        private static TagKey<PoiType> tag(@NotNull String modid, @NotNull String name) {
            return TagKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)new ResourceLocation(modid, name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> IS_WEREWOLF_BIOME = Biomes.tag("has_faction/werewolf");

        @NotNull
        private static TagKey<Biome> tag(@NotNull String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation("werewolves", name));
        }

        public static class NoSpawn {
            public static final TagKey<Biome> WEREWOLF = Biomes.tag("no_spawn/werewolf");
            public static final TagKey<Biome> HUMAN_WEREWOLF = Biomes.tag("no_spawn/human_werewolf");
        }

        public static class HasSpawn {
            public static final TagKey<Biome> WEREWOLF = Biomes.tag("has_spawn/werewolf");
            public static final TagKey<Biome> HUMAN_WEREWOLF = Biomes.tag("has_spawn/human_werewolf");
        }

        public static class HasGen {
            public static final TagKey<Biome> SILVER_ORE = Biomes.tag("has_gen/silver_ore");
            public static final TagKey<Biome> WOLFSBANE = Biomes.tag("has_gen/wolfsbane");
        }
    }

    public static class Items
    extends ModTags.Items {
        public static final TagKey<Item> SILVER_ORE = Items.forge("ores/silver");
        public static final TagKey<Item> SILVER_INGOT = Items.forge("ingots/silver");
        public static final TagKey<Item> SILVER_NUGGET = Items.forge("nuggets/silver");
        public static final TagKey<Item> RAW_MEAT = Items.forge("rawmeats");
        public static final TagKey<Item> COOKED_MEAT = Items.forge("cookedmeats");
        public static final TagKey<Item> RAW_FISH = Items.werewolves("raw_fish");
        public static final TagKey<Item> COOKED_FISH = Items.werewolves("cooked_fish");
        public static final TagKey<Item> RAW_FOOD = Items.werewolves("raw_food");
        @Deprecated
        public static final TagKey<Item> MEAT = Items.werewolves("meat");
        public static final TagKey<Item> WEREWOLF_FOOD = Items.werewolves("werewolf_food");
        public static final TagKey<Item> SILVER_TOOL = Items.werewolves("tools/silver");
        public static final TagKey<Item> SILVER_ARMOR = Items.werewolves("armor/silver");
        public static final TagKey<Item> SILVER_ITEM = Items.werewolves("type/silver");
        public static final TagKey<Item> RAW_MATERIALS_SILVER = Items.forge("raw_materials/silver");
        public static final TagKey<Item> STORAGE_BLOCKS_SILVER = Items.forge("storage_blocks/silver");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_SILVER = Items.forge("storage_blocks/raw_silver");
        public static final TagKey<Item> MAGIC_LOG = Items.forge("magic_log");
        public static final TagKey<Item> JACARANDA_LOG = Items.forge("jacaranda_log");
        public static final TagKey<Item> WOLF_PELT_ARMOR_NORMAL = Items.werewolves("armor/wolf_pelt/normal");
        public static final TagKey<Item> WOLF_PELT_ARMOR_ENHANCED = Items.werewolves("armor/wolf_pelt/enhanced");
        public static final TagKey<Item> WOLF_PELT_ARMOR_ULTIMATE = Items.werewolves("armor/wolf_pelt/ultimate");
        public static final TagKey<Item> WOLF_PELT_ARMOR = Items.werewolves("armor/wolf_pelt");

        private static TagKey<Item> mc(ResourceLocation id) {
            return ItemTags.create((ResourceLocation)id);
        }

        private static TagKey<Item> werewolves(String id) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("werewolves", id));
        }

        private static TagKey<Item> forge(String id) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("forge", id));
        }
    }

    public static class Blocks
    extends ModTags.Blocks {
        public static final TagKey<Block> SILVER_ORE = Blocks.forge("ores/silver");
        public static final TagKey<Block> STORAGE_BLOCKS_SILVER = Blocks.forge("storage_blocks/silver");
        public static final TagKey<Block> STORAGE_BLOCKS_RAW_SILVER = Blocks.forge("storage_blocks/raw_silver");
        public static final TagKey<Block> MAGIC_LOG = Blocks.forge("magic_log");
        public static final TagKey<Block> JACARANDA_LOG = Blocks.forge("jacaranda_log");
        public static final TagKey<Block> NEEDS_SILVER_TOOL = Blocks.forge("needs_silver_tool");

        private static TagKey<Block> mc(ResourceLocation id) {
            return BlockTags.create((ResourceLocation)id);
        }

        private static TagKey<Block> werewolves(String id) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("werewolves", id));
        }

        private static TagKey<Block> forge(String id) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", id));
        }
    }
}

