/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.core.ModModelRender;
import de.teamlapen.werewolves.client.model.WerewolfBeastModel;
import de.teamlapen.werewolves.client.render.WerewolfPlayerRenderer;
import de.teamlapen.werewolves.client.render.layer.BeastItemInHandLayer;
import de.teamlapen.werewolves.client.render.layer.WerewolfFormFaceOverlayLayer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.NotNull;

public class WerewolfPlayerBeastRenderer
extends WerewolfPlayerRenderer<AbstractClientPlayer, WerewolfBeastModel<AbstractClientPlayer>> {
    private final List<ResourceLocation> textures = WerewolfBeastModel.getBeastTextures();

    public WerewolfPlayerBeastRenderer(EntityRendererProvider.Context context) {
        super(context, new WerewolfBeastModel(context.bakeLayer(ModModelRender.WEREWOLF_BEAST)), 1.0f);
        this.addLayer(new WerewolfFormFaceOverlayLayer(WerewolfForm.BEAST, this));
        this.addLayer((RenderLayer)new BeastItemInHandLayer(this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AbstractClientPlayer player) {
        WerewolfPlayer werewolf = WerewolfPlayer.get((Player)player);
        return this.textures.get(werewolf.getSkinType(WerewolfForm.BEAST) % this.textures.size());
    }

    @Override
    public void renderRightHand(PoseStack stack, MultiBufferSource bufferSource, int p_117773_, AbstractClientPlayer entity) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)stack, (MultiBufferSource)bufferSource, (int)p_117773_, (AbstractClientPlayer)entity, (HumanoidArm)HumanoidArm.RIGHT)) {
            this.renderHand(stack, bufferSource, p_117773_, entity, ((WerewolfBeastModel)this.model).getRightArmModel());
        }
    }

    @Override
    public void renderLeftHand(PoseStack stack, MultiBufferSource bufferSource, int p_117816_, AbstractClientPlayer entity) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)stack, (MultiBufferSource)bufferSource, (int)p_117816_, (AbstractClientPlayer)entity, (HumanoidArm)HumanoidArm.LEFT)) {
            this.renderHand(stack, bufferSource, p_117816_, entity, ((WerewolfBeastModel)this.model).getLeftArmModel());
        }
    }

    @Override
    protected void setupSwimRotations(AbstractClientPlayer pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        float f3 = pEntityLiving.isInWater() || pEntityLiving.isInFluidType((fluidType, height) -> pEntityLiving.canSwimInFluidType(fluidType)) ? -70.0f - pEntityLiving.getXRot() : -70.0f;
        float f4 = Mth.lerp((float)pEntityLiving.getSwimAmount(pPartialTicks), (float)0.0f, (float)f3);
        pMatrixStack.mulPose(Axis.XP.rotationDegrees(f4));
        if (pEntityLiving.isVisuallySwimming()) {
            pMatrixStack.translate(0.0f, -1.0f, 0.3f);
        }
    }
}

