/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class WerewolfSurvivalistModel<T extends LivingEntity>
extends WerewolfBaseModel<T> {
    public static final String BODY = "body";
    public static final String HIP = "hip";
    public static final String NECK = "neck";
    public static final String ARM_LEFT = "armLeft";
    public static final String ARM_RIGHT = "armRight";
    public static final String BODY_FLUFF = "bodyFluff";
    public static final String LEG_LEFT = "legLeft";
    public static final String LEG_RIGHT = "legRight";
    public static final String TAIL = "tail";
    public static final String LEG_LEFT_2 = "legLeft2";
    public static final String FOOT_LEFT = "footLeft";
    public static final String LEG_RIGHT_2 = "legRight2";
    public static final String FOOT_RIGHT = "footRight";
    public static final String TAIL_2 = "tail2";
    public static final String TAIL_3 = "tail3";
    public static final String JOINT = "joint";
    public static final String NECK_FLUFF = "neckFluff";
    public static final String NECK_FLUFF_LEFT = "neckFluffLeft";
    public static final String NECK_FLUFF_RIGHT = "neckFluffRight";
    public static final String NECK_FLUFF_BOTTOM = "neckFluffBottom";
    public static final String HEAD = "head";
    public static final String EAR_LEFT = "earLeft";
    public static final String EAR_RIGHT = "earRight";
    public static final String SNOUT = "snout";
    public static final String JAW = "jaw";
    public static final String HEAD_FLUFF = "headFluff";
    public static final String HEAD_SIDEBURNS_LEFT = "headSideburnsLeft";
    public static final String HEAD_SIDEBURNS_RIGHT = "headSideburnsRight";
    public static final String NOSE = "nose";
    public static final String SNOUT_TEETH = "snoutTeeth";
    public static final String JAW_TEETH = "jawTeeth";
    public static final String JAW_FLUFF = "jawFluff";
    public static final String ARM_LEFT_2 = "armLeft2";
    public static final String FOOT_LEFT_1 = "footLeft_1";
    public static final String ARM_RIGHT_2 = "armRight2";
    public static final String FOOT_LEFT_2 = "footLeft_2";
    public final ModelPart head;
    public final ModelPart hip;
    public final ModelPart body;
    public final ModelPart armLeft;
    public final ModelPart armRight;
    public final ModelPart legRight;
    public final ModelPart legLeft;
    public final ModelPart tail;
    public final ModelPart jaw;
    public final ModelPart jawTeeth;
    public final ModelPart neck;
    public final ModelPart joint;
    private final List<ModelPart> parts;

    public WerewolfSurvivalistModel(ModelPart part) {
        super(part);
        this.body = part.getChild(BODY);
        this.hip = this.body.getChild(HIP);
        this.tail = this.hip.getChild(TAIL);
        this.legRight = this.hip.getChild(LEG_RIGHT);
        this.legLeft = this.hip.getChild(LEG_LEFT);
        this.armLeft = this.body.getChild(ARM_LEFT);
        this.armRight = this.body.getChild(ARM_RIGHT);
        this.neck = this.body.getChild(NECK);
        this.joint = this.neck.getChild(JOINT);
        this.head = this.joint.getChild(HEAD);
        this.jaw = this.head.getChild(JAW);
        this.jawTeeth = this.jaw.getChild(JAW_TEETH);
        this.parts = part.getAllParts().filter(s -> !s.isEmpty()).toList();
    }

    @Nonnull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = WerewolfBaseModel.createMesh(CubeDeformation.NONE);
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild(BODY, CubeListBuilder.create().texOffs(0, 13).addBox(-4.5f, 0.0f, -4.0f, 9.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)9.5f, (float)-2.5f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild(NECK, CubeListBuilder.create().texOffs(0, 45).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)1.0f, (float)-0.31415927f, (float)0.0f, (float)0.0f));
        PartDefinition joint = neck.addOrReplaceChild(JOINT, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)-1.0f, (float)-1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition head = joint.addOrReplaceChild(HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition snout = head.addOrReplaceChild(SNOUT, CubeListBuilder.create().texOffs(34, 0).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.offset((float)0.0f, (float)2.0f, (float)-5.0f));
        PartDefinition jaw = head.addOrReplaceChild(JAW, CubeListBuilder.create().texOffs(50, 0).addBox(-1.5f, 0.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)-5.0f, (float)0.4553564f, (float)0.0f, (float)0.0f));
        PartDefinition hip = body.addOrReplaceChild(HIP, CubeListBuilder.create().texOffs(0, 30).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 9.0f, 6.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-0.9f));
        PartDefinition armLeft = body.addOrReplaceChild(ARM_LEFT, CubeListBuilder.create().texOffs(36, 25).addBox(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).mirror(), PartPose.offsetAndRotation((float)1.5f, (float)3.0f, (float)-1.5f, (float)1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition armLeft2 = armLeft.addOrReplaceChild(ARM_LEFT_2, CubeListBuilder.create().texOffs(48, 15).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 8.0f, 4.0f).mirror(), PartPose.offsetAndRotation((float)2.0f, (float)5.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition footLeft_1 = armLeft2.addOrReplaceChild(FOOT_LEFT_1, CubeListBuilder.create().texOffs(24, 54).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f).mirror(), PartPose.offset((float)0.0f, (float)7.0f, (float)-0.5f));
        PartDefinition snoutTeeth = snout.addOrReplaceChild(SNOUT_TEETH, CubeListBuilder.create().texOffs(34, 6).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.ZERO);
        PartDefinition bodyFluff = body.addOrReplaceChild(BODY_FLUFF, CubeListBuilder.create().texOffs(82, 14).addBox(-4.5f, 8.0f, -4.0f, 9.0f, 3.0f, 8.0f), PartPose.ZERO);
        PartDefinition legRight = hip.addOrReplaceChild(LEG_RIGHT, CubeListBuilder.create().texOffs(24, 39).addBox(-4.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)-0.5f, (float)8.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft = hip.addOrReplaceChild(LEG_LEFT, CubeListBuilder.create().texOffs(24, 39).addBox(0.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.5f, (float)8.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft2 = legLeft.addOrReplaceChild(LEG_LEFT_2, CubeListBuilder.create().texOffs(44, 44).addBox(0.5f, 2.0f, 1.0f, 3.0f, 10.0f, 4.0f).mirror(), PartPose.ZERO);
        PartDefinition tail = hip.addOrReplaceChild(TAIL, CubeListBuilder.create().texOffs(62, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)2.0f, (float)-0.22759093f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.addOrReplaceChild(TAIL_2, CubeListBuilder.create().texOffs(62, 37).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild(TAIL_3, CubeListBuilder.create().texOffs(62, 49).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.8f, (float)0.0f, (float)0.13665928f, (float)0.0f, (float)0.0f));
        PartDefinition headSideburnsLeft = head.addOrReplaceChild(HEAD_SIDEBURNS_LEFT, CubeListBuilder.create().texOffs(32, 12).addBox(1.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f), PartPose.rotation((float)0.0f, (float)-0.5235988f, (float)0.0f));
        PartDefinition neckFluffRight = neck.addOrReplaceChild(HEAD_SIDEBURNS_RIGHT, CubeListBuilder.create().texOffs(82, 25).addBox(-3.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.rotation((float)0.34906584f, (float)-1.5707964f, (float)0.0f));
        PartDefinition footLeft = legLeft2.addOrReplaceChild(FOOT_LEFT, CubeListBuilder.create().texOffs(24, 54).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f).mirror(), PartPose.offset((float)2.0f, (float)12.0f, (float)2.5f));
        PartDefinition headFluff = head.addOrReplaceChild(HEAD_FLUFF, CubeListBuilder.create().texOffs(96, 0).addBox(-3.5f, 3.5f, -5.0f, 7.0f, 2.0f, 6.0f), PartPose.ZERO);
        PartDefinition legRight2 = legRight.addOrReplaceChild(LEG_RIGHT_2, CubeListBuilder.create().texOffs(44, 44).addBox(-3.5f, 2.0f, 1.0f, 3.0f, 10.0f, 4.0f), PartPose.ZERO);
        PartDefinition earRight = head.addOrReplaceChild(EAR_RIGHT, CubeListBuilder.create().texOffs(26, 0).addBox(-3.5f, -6.5f, -1.0f, 2.0f, 3.0f, 1.0f), PartPose.ZERO);
        PartDefinition headSideburnsRight = head.addOrReplaceChild(HEAD_SIDEBURNS_RIGHT, CubeListBuilder.create().texOffs(32, 12).addBox(-4.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f).mirror(), PartPose.rotation((float)0.0f, (float)0.5235988f, (float)0.0f));
        PartDefinition jawFluff = jaw.addOrReplaceChild(JAW_FLUFF, CubeListBuilder.create().texOffs(96, 8).addBox(-1.5f, 2.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.ZERO);
        PartDefinition footRight = legRight2.addOrReplaceChild(FOOT_RIGHT, CubeListBuilder.create().texOffs(24, 54).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)2.5f));
        PartDefinition neckFluff = neck.addOrReplaceChild(NECK_FLUFF, CubeListBuilder.create().texOffs(64, 19).addBox(-3.5f, -5.0f, 2.5f, 7.0f, 8.0f, 2.0f), PartPose.rotation((float)0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = body.addOrReplaceChild(ARM_RIGHT, CubeListBuilder.create().texOffs(36, 25).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)-1.5f, (float)3.0f, (float)-1.5f, (float)-1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition armRight2 = armRight.addOrReplaceChild(ARM_RIGHT_2, CubeListBuilder.create().texOffs(48, 15).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)-2.0f, (float)5.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition neckFluffLeft = neck.addOrReplaceChild(NECK_FLUFF_LEFT, CubeListBuilder.create().texOffs(82, 25).addBox(-2.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.rotation((float)0.34906584f, (float)1.5707964f, (float)0.0f));
        PartDefinition neckFluffBottom = neck.addOrReplaceChild(NECK_FLUFF_BOTTOM, CubeListBuilder.create().texOffs(80, 0).addBox(-3.0f, -0.6f, 4.5f, 6.0f, 6.0f, 2.0f), PartPose.rotation((float)1.0471976f, (float)((float)Math.PI), (float)0.0f));
        PartDefinition earLeft = head.addOrReplaceChild(EAR_LEFT, CubeListBuilder.create().texOffs(26, 0).addBox(1.5f, -6.5f, -1.0f, 2.0f, 3.0f, 1.0f).mirror(), PartPose.ZERO);
        PartDefinition nose = snout.addOrReplaceChild(NOSE, CubeListBuilder.create().texOffs(64, 0).addBox(-1.5f, -3.5f, -3.7f, 3.0f, 2.0f, 5.0f), PartPose.rotation((float)0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition jawTeeth = jaw.addOrReplaceChild(JAW_TEETH, CubeListBuilder.create().texOffs(50, 6).addBox(-1.5f, -1.0f, -3.5f, 3.0f, 1.0f, 4.0f), PartPose.ZERO);
        PartDefinition footLeft_2 = armRight2.addOrReplaceChild(FOOT_LEFT_2, CubeListBuilder.create().texOffs(24, 54).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f), PartPose.offset((float)0.0f, (float)7.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    @Override
    @Nullable
    public ModelPart getModelRenderer() {
        return this.body;
    }

    @Override
    @Nullable
    public ModelPart getHeadModel() {
        return this.head;
    }

    @Override
    @Nullable
    public ModelPart getLeftArmModel() {
        return this.armLeft;
    }

    @Override
    @Nullable
    public ModelPart getRightArmModel() {
        return this.armRight;
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void renderToBuffer(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void setupAnim(@Nonnull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.crouching = entityIn.isCrouching();
        boolean flag1 = entityIn.isVisuallySwimming();
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.setupAttackAnimation(entityIn, ageInTicks);
        this.legRight.xRot = -1.5707964f;
        this.legLeft.xRot = -1.5707964f;
        this.armRight.xRot = -1.2217305f;
        this.armLeft.xRot = -1.2217305f;
        this.legRight.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.8f + 4.712389f)) * 0.8f * limbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.8f + 1.5707964f)) * 0.8f * limbSwingAmount;
        this.armRight.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.8f)) * 0.8f * limbSwingAmount;
        this.armLeft.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.8f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        if (this.crouching) {
            this.armLeft.xRot -= 0.4f;
            this.armRight.xRot -= 0.4f;
            this.legLeft.xRot += 0.1f;
            this.legRight.xRot += 0.1f;
            this.body.y = 10.5f;
            this.neck.xRot = -0.11415926f;
            this.hip.xRot = 0.05f;
            this.hip.y = 7.0f;
        } else {
            this.body.y = 9.5f;
            this.neck.xRot = -0.31415927f;
            this.hip.xRot = 0.0f;
            this.hip.y = 6.0f;
        }
        this.tail.xRot = -0.22759093f;
        this.tail.xRot -= 0.035f;
        this.tail.xRot += Mth.cos((float)(ageInTicks * 0.1f)) * 0.07f;
        this.tail.yRot = -0.035f;
        this.tail.yRot += Mth.sin((float)(ageInTicks * 0.14f)) * 0.07f;
        this.tail.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f)) * 0.3f * Mth.abs((float)limbSwingAmount) + 0.3f;
        this.tail.yRot += Mth.sin((float)(limbSwing * 0.6662f * 0.7f)) * 0.1f * limbSwingAmount;
    }

    @Override
    @NotNull
    protected ModelPart getArm(@NotNull HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.armRight : this.armLeft;
    }

    public void translateToMouth(@NotNull HumanoidArm arm, @NotNull PoseStack stack) {
        this.body.translateAndRotate(stack);
        this.neck.translateAndRotate(stack);
        this.joint.translateAndRotate(stack);
        this.head.translateAndRotate(stack);
        this.jaw.translateAndRotate(stack);
    }

    protected void setupAttackAnimation(@NotNull T entity, float ageInTicks) {
        if (this.attackTime > 0.0f) {
            float f = this.attackTime;
            f = 1.0f - f;
            this.head.xRot += f;
        }
    }

    @Nonnull
    public static List<ResourceLocation> getSurvivalTextures() {
        List<ResourceLocation> locs = WerewolfSurvivalistModel.getTextures("textures/entity/werewolf/survivalist");
        if (locs.size() < WerewolfForm.SURVIVALIST.getSkinTypes()) {
            for (int i = locs.size(); i < WerewolfForm.SURVIVALIST.getSkinTypes(); ++i) {
                ResourceLocation s = new ResourceLocation("werewolves", "textures/entity/werewolf/survivalist/survivalist_" + i + ".png");
                locs.add(s);
            }
        }
        return locs;
    }

    @NotNull
    public ModelPart getRandomModelPart(RandomSource pRandom) {
        return this.parts.get(pRandom.nextInt(this.parts.size()));
    }
}

