/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks.entity;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.werewolves.blocks.WolfsbaneDiffuserBlock;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.world.LevelWolfsbane;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfsbaneDiffuserBlockEntity
extends BlockEntity {
    private static final int FUEL_DURATION = 2400;
    private WolfsbaneDiffuserBlock.Type type = WolfsbaneDiffuserBlock.Type.NORMAL;
    private int id;
    private boolean registered = false;
    private int fueled = 0;
    private int bootTimer = -1;
    private int maxBootTimer;
    private boolean initiateBootTimer = false;

    public WolfsbaneDiffuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.WOLFSBANE_DIFFUSER.get(), pPos, pBlockState);
    }

    public float getBootProgress() {
        return this.bootTimer > 0 ? 1.0f - (float)this.bootTimer / (float)this.maxBootTimer : 1.0f;
    }

    public int getFuelTime() {
        return this.fueled;
    }

    public float getFueledState() {
        return (float)this.fueled / (float)this.type.fuelTime.get().intValue();
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (this.isActive()) {
            this.register();
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean isActive() {
        return this.bootTimer == 0;
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public boolean isInRange(@NotNull BlockPos pos) {
        return new ChunkPos(this.getBlockPos()).getChessboardDistance(new ChunkPos(pos)) <= this.radius();
    }

    public void load(@NotNull CompoundTag compound) {
        super.load(compound);
        this.type = WolfsbaneDiffuserBlock.Type.valueOf(compound.getString("type"));
        this.bootTimer = compound.getInt("boot_timer");
        this.maxBootTimer = compound.contains("max_boot_timer") ? compound.getInt("max_boot_timer") : 1;
        this.setFueledTime(compound.getInt("fueled"));
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        if (this.hasLevel()) {
            CompoundTag nbt = pkt.getTag();
            this.handleUpdateTag(nbt);
            if (this.isActive()) {
                this.register();
            }
        }
    }

    public void onTouched(@NotNull Player player) {
    }

    private int radius() {
        return this.type.range.get();
    }

    public void onFueled() {
        this.setFueledTime(this.type.fuelTime.get());
        this.updateLevel();
    }

    public void setNewBootDelay(int delayTicks) {
        this.bootTimer = delayTicks;
        this.maxBootTimer = delayTicks;
    }

    public void saveAdditional(@NotNull CompoundTag compound) {
        super.saveAdditional(compound);
        compound.putString("type", this.type.name());
        compound.putInt("fueled", this.fueled);
        if (this.bootTimer != 0) {
            compound.putInt("boot_timer", this.bootTimer);
            compound.putInt("max_boot_timer", this.maxBootTimer);
        }
    }

    public void initiateBootTimer() {
        this.initiateBootTimer = true;
    }

    public void setType(WolfsbaneDiffuserBlock.Type type) {
        this.type = type;
    }

    public void updateLevel() {
        this.setChanged();
        if (this.hasLevel()) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        this.unregister();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, @NotNull WolfsbaneDiffuserBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (blockEntity.initiateBootTimer) {
                blockEntity.initiateBootTimer = false;
                int bootTime = (Integer)VampirismConfig.BALANCE.garlicDiffuserStartupTime.get() * 20;
                if (serverLevel.players().size() <= 1) {
                    bootTime >>= 2;
                }
                if (blockEntity.type == WolfsbaneDiffuserBlock.Type.LONG) {
                    bootTime *= 2;
                }
                blockEntity.bootTimer = bootTime;
                blockEntity.maxBootTimer = bootTime;
                blockEntity.updateLevel();
            }
        }
        if (blockEntity.bootTimer > 0) {
            if (--blockEntity.bootTimer == 0) {
                blockEntity.updateLevel();
                blockEntity.register();
            }
        } else if (blockEntity.fueled > 0) {
            if (blockEntity.fueled == 1) {
                blockEntity.setFueledTime(0);
                blockEntity.updateLevel();
            } else {
                --blockEntity.fueled;
                blockEntity.setChanged();
            }
        }
    }

    private void register() {
        if (this.registered || !this.hasLevel()) {
            return;
        }
        int baseX = this.getBlockPos().getX() >> 4;
        int baseZ = this.getBlockPos().getZ() >> 4;
        int radius = this.radius();
        ChunkPos[] chunks = new ChunkPos[(2 * radius + 1) * (2 * radius + 1)];
        int i = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                chunks[i++] = new ChunkPos(x + baseX, z + baseZ);
            }
        }
        this.id = LevelWolfsbane.getOpt(this.getLevel()).map(s -> s.registerWolfsbaneDiffuserBlock(this.fueled > 0 ? this.type.amplifier : 0, chunks)).orElse(0);
        this.registered = i != 0;
    }

    private void setFueledTime(int time) {
        int old = this.fueled;
        this.fueled = time;
        if ((time > 0 && old == 0 || time == 0 && old > 0) && !this.isRemoved()) {
            this.unregister();
            this.register();
        }
    }

    private void unregister() {
        if (this.registered && this.hasLevel()) {
            LevelWolfsbane.getOpt(this.getLevel()).ifPresent(vw -> vw.removeWolfsbaneBlocksBlock(this.id));
            this.registered = false;
        }
    }
}

