/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.werewolves.GeneralEventHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.WerewolvesModClient;
import de.teamlapen.werewolves.command.arguments.WerewolfFormArgument;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttachments;
import de.teamlapen.werewolves.core.ModCommands;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModLootTables;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.core.RegistryManager;
import de.teamlapen.werewolves.entities.ModEntityEventHandler;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.player.ModPlayerEventHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.items.WerewolfRefinementItem;
import de.teamlapen.werewolves.modcompat.terrablender.TerraBlenderCompat;
import de.teamlapen.werewolves.network.ModPacketDispatcher;
import de.teamlapen.werewolves.proxy.Proxy;
import de.teamlapen.werewolves.proxy.ServerProxy;
import de.teamlapen.werewolves.util.LordTitles;
import de.teamlapen.werewolves.util.Permissions;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WUtils;
import de.teamlapen.werewolves.util.WerewolfVillageData;
import de.teamlapen.werewolves.world.gen.OverworldModifications;
import de.teamlapen.werewolves.world.gen.WerewolvesBiomeFeatures;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.Container;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="werewolves")
public class WerewolvesMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Proxy proxy = FMLEnvironment.dist == Dist.CLIENT ? WerewolvesModClient.getProxy() : new ServerProxy();
    public static final MobCategory WEREWOLF_CREATURE_TYPE = MobCategory.create((String)"werewolves_werewolf", (String)"werewolves_werewolf", (int)8, (boolean)false, (boolean)false, (int)128);
    private static final MobType WEREWOLF_CREATURE_ATTRIBUTES = new MobType();
    public static WerewolvesMod instance;
    public final RegistryManager registryManager;
    private boolean setupAPI;

    public WerewolvesMod(IEventBus modEventBus) {
        instance = this;
        this.registryManager = new RegistryManager(modEventBus);
        WUtils.init();
        Optional opt = ModList.get().getModContainerById("vampirism");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::setUpClient);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::blockRegister);
        modEventBus.register(ModPacketDispatcher.class);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.register((Object)new WerewolvesModClient(modEventBus, this.registryManager));
        }
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.addListener(ModLootTables::onLootLoad);
        NeoForge.EVENT_BUS.register(Permissions.class);
        RegistryManager.setupRegistries(modEventBus);
        WerewolvesBiomeFeatures.register(modEventBus);
        modEventBus.addListener(ModItems::registerOtherCreativeTabItems);
        WerewolvesConfig.registerConfigs(modEventBus);
    }

    private void setupAPI() {
        if (!this.setupAPI) {
            WReference.WEREWOLF_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.WEREWOLF_PLAYER_KEY, IWerewolfPlayer.class, () -> (AttachmentType)ModAttachments.WEREWOLF_PLAYER.get()).color(Color.orange.getRGB()).hostileTowardsNeutral().highestLevel(14).lord().lordLevel(5).lordTitle(LordTitles::getWerewolfTitle).enableLordSkills().minion(WerewolfMinionEntity.WerewolfMinionData.ID, WerewolfMinionEntity.WerewolfMinionData::new).commandBuilder(() -> ModEntities.WEREWOLF_MINION.get()).with("name", (Object)"Werewolf", (ArgumentType)StringArgumentType.string(), MinionData::setName, StringArgumentType::getString).with("skin", (Object)-1, (ArgumentType)IntegerArgumentType.integer((int)-1), WerewolfMinionEntity.WerewolfMinionData::setSkinType, IntegerArgumentType::getInteger).with("eye", (Object)-1, (ArgumentType)IntegerArgumentType.integer((int)-1), WerewolfMinionEntity.WerewolfMinionData::setEyeType, IntegerArgumentType::getInteger).with("glowingEye", (Object)false, (ArgumentType)BoolArgumentType.bool(), WerewolfMinionEntity.WerewolfMinionData::setGlowingEyes, BoolArgumentType::getBool).with("form", (Object)WerewolfForm.BEAST, (ArgumentType)WerewolfFormArgument.nonHumanForms(), WerewolfMinionEntity.WerewolfMinionData::setForm, WerewolfFormArgument::getForm).build().build().build().village(WerewolfVillageData::werewolfVillage).chatColor(ChatFormatting.GOLD).name("text.werewolves.werewolf").namePlural("text.vampirism.werewolves").refinementItems(WerewolfRefinementItem::getRefinementItem).addTag(Registries.BIOME, ModTags.Biomes.IS_WEREWOLF_BIOME).addTag(Registries.POINT_OF_INTEREST_TYPE, ModTags.PoiTypes.IS_WEREWOLF).addTag(Registries.VILLAGER_PROFESSION, ModTags.Professions.IS_WEREWOLF).addTag(Registries.ENTITY_TYPE, ModTags.Entities.WEREWOLF).addTag(VampirismRegistries.Keys.TASK, ModTags.Tasks.IS_WEREWOLF).register();
            WReference.WEREWOLF_CREATURE_ATTRIBUTES = WEREWOLF_CREATURE_ATTRIBUTES;
            this.setupAPI = true;
        }
    }

    private void blockRegister(RegisterEvent event) {
        this.setupAPI();
    }

    private void setup(@NotNull FMLCommonSetupEvent event) {
        this.setupAPI();
        this.registryManager.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        NeoForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        NeoForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        NeoForge.EVENT_BUS.register((Object)new GeneralEventHandler());
        event.enqueueWork(TerraBlenderCompat::registerBiomeProviderIfPresentUnsafe);
    }

    private void loadComplete(@NotNull FMLLoadCompleteEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        event.enqueueWork(OverworldModifications::addBiomesToOverworldUnsafe);
    }

    private void processIMC(@NotNull InterModProcessEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        HelperRegistry.registerPlayerEventReceivingCapability((AttachmentType)((AttachmentType)ModAttachments.WEREWOLF_PLAYER.get()), WerewolfPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability((AttachmentType)((AttachmentType)ModAttachments.WEREWOLF_PLAYER.get()), WerewolfPlayer.class);
    }

    private void setUpClient(FMLClientSetupEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void onCommandsRegister(@NotNull RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModTiles.STONE_ALTAR.get(), (o, side) -> new InvWrapper((Container)o));
    }
}

