/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.modcompat.terrablender;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBiomes;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.RegionUtils;

public class TerraBlenderRegistration {
    public static void registerRegions() {
        Regions.register((Region)new ForestRegion());
    }

    static class ForestRegion
    extends Region {
        public ForestRegion() {
            super(new ResourceLocation("werewolves", "overworld"), RegionType.OVERWORLD, ((Integer)WerewolvesConfig.COMMON.werewolfBiomeWeightTerrablender.get()).intValue());
        }

        public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
            this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
                ArrayList points = new ArrayList(RegionUtils.getVanillaParameterPoints((ResourceKey)Biomes.FOREST));
                points.addAll(RegionUtils.getVanillaParameterPoints((ResourceKey)Biomes.DARK_FOREST));
                points.forEach(point -> builder.replaceBiome(point, ModBiomes.WEREWOLF_FOREST));
            });
        }
    }
}

