/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items;

import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LiverItem
extends Item {
    public LiverItem() {
        super(new Item.Properties().food(new FoodProperties.Builder().meat().nutrition(6).saturationMod(0.4f).build()));
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity entityLiving) {
        assert (stack.getItem().getFoodProperties() != null);
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            VampirePlayer.getOpt((Player)player).ifPresent(v -> v.drinkBlood(stack.getItem().getFoodProperties().getNutrition(), stack.getItem().getFoodProperties().getSaturationModifier()));
            worldIn.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.9f);
            entityLiving.eat(worldIn, stack);
        } else if (entityLiving instanceof IVampire) {
            ((IVampire)entityLiving).drinkBlood(stack.getItem().getFoodProperties().getNutrition(), stack.getItem().getFoodProperties().getSaturationModifier());
            stack.shrink(1);
        } else {
            entityLiving.eat(worldIn, stack);
        }
        return stack;
    }
}

