/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.items.ISilverItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.effects.SilverEffect;
import de.teamlapen.werewolves.effects.inst.UnWerewolfEffectInstance;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.items.UnWerewolfInjectionItem;
import de.teamlapen.werewolves.mixin.LivingEntityAccessor;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.REFERENCE;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            try {
                event.addCapability(REFERENCE.WEREWOLF_PLAYER_KEY, WerewolfPlayer.createNewCapability((Player)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public void onFootEatenFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity()) && event.getItem().getItem() instanceof VampirismItemBloodFoodItem) {
            event.getEntity().removeEffect(MobEffects.CONFUSION);
        }
    }

    @SubscribeEvent
    public void onKilled(LivingDeathEvent event) {
        if (!Helper.isNoLiving(event.getEntity()) && event.getSource().getEntity() instanceof Player && Helper.isWerewolf((Player)event.getSource().getEntity())) {
            WerewolfPlayer player = WerewolfPlayer.get((Player)event.getSource().getEntity());
            if (player.getSkillHandler().isSkillEnabled((ISkill)ModSkills.HEALTH_AFTER_KILL.get())) {
                ((Player)event.getSource().getEntity()).addEffect(new MobEffectInstance(MobEffects.REGENERATION, player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.HEALTH_AFTER_KILL.get()) ? 5 : 4, 10));
            }
            ((Player)event.getSource().getEntity()).getFoodData().setSaturation(((Player)event.getSource().getEntity()).getFoodData().getSaturationLevel() + 0.5f);
        }
    }

    @SubscribeEvent
    public void onFall(PlayerFlyableFallEvent event) {
        if (Helper.isWerewolf(event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get(event.getEntity());
            if (werewolf.getSpecialAttributes().leap) {
                ((ActionHandler)werewolf.getActionHandler()).deactivateAction((ILastingAction)ModActions.LEAP.get(), false, true);
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())) {
                event.setDistance(event.getDistance() * 0.8f);
                event.setDamageMultiplier(event.getDamageMultiplier() * 0.8f);
            }
            if (werewolf.getSpecialAttributes().leap) {
                ((ActionHandler)werewolf.getActionHandler()).deactivateAction((ILastingAction)ModActions.LEAP.get(), false, true);
            }
            if (werewolf.getForm().isTransformed() && werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.JUMP.get())) {
                event.setDistance(event.getDistance() - 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if (event.getSlot() == EquipmentSlot.MAINHAND && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            WerewolfPlayer.getOpt(player).ifPresent(s -> s.checkToolDamage(event.getFrom(), event.getTo(), false));
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity())) {
            LivingEntity entity = event.getEntity();
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)entity);
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())) {
                Vec3 motion = entity.getDeltaMovement().multiply(1.1, 1.2, 1.1);
                entity.setDeltaMovement(motion);
            }
            if (werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.LEAP.get()) && !werewolf.getSpecialAttributes().leap) {
                werewolf.getSpecialAttributes().leap = true;
                Vec3 viewVector = entity.getViewVector(0.0f);
                Vec3 leap = new Vec3(viewVector.x, (double)((LivingEntityAccessor)entity).invokeGetJumpPower_werewolves() * 0.5, viewVector.z);
                float leapModifier = werewolf.getForm().getLeapModifier();
                entity.addDeltaMovement(leap.multiply((double)leapModifier, (double)leapModifier, (double)leapModifier));
            }
            if (werewolf.getForm().isTransformed() && werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.JUMP.get())) {
                entity.addDeltaMovement(new Vec3(0.0, 0.05, 0.0));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWakeUp(PlayerWakeUpEvent event) {
        if (!event.getEntity().level().isClientSide && event.getEntity().getEffect((MobEffect)ModEffects.LUPUS_SANGUINEM.get()) != null) {
            event.getEntity().getEffect((MobEffect)ModEffects.LUPUS_SANGUINEM.get()).applyEffect((LivingEntity)event.getEntity());
            event.getEntity().removeEffect((MobEffect)ModEffects.LUPUS_SANGUINEM.get());
        }
    }

    @SubscribeEvent
    public void onItemUseEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().getItemInHand(event.getHand()).getItem() == ModItems.V.INJECTION_EMPTY.get() && event.getTarget() instanceof WerewolfBaseEntity) {
            event.getEntity().getItemInHand(event.getHand()).shrink(1);
            event.getEntity().addItem(((UnWerewolfInjectionItem)((Object)ModItems.INJECTION_UN_WEREWOLF.get())).getDefaultInstance());
        }
    }

    @SubscribeEvent
    public void onItemUseBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.getItemInHand(event.getHand()).getItem() == ModItems.INJECTION_UN_WEREWOLF.get()) {
            if (event.getLevel().getBlockState(event.getPos()).getBlock() == ModBlocks.V.MED_CHAIR.get()) {
                ItemStack stack = player.getItemInHand(event.getHand());
                if (player.isAlive()) {
                    FactionPlayerHandler.getOpt((Player)event.getEntity()).resolve().map(FactionPlayerHandler::getCurrentFaction).filter(faction -> {
                        if (WReference.WEREWOLF_FACTION.equals(faction)) {
                            if (player.getEffect((MobEffect)ModEffects.UN_WEREWOLF.get()) == null) {
                                player.addEffect((MobEffectInstance)new UnWerewolfEffectInstance(2000));
                                return true;
                            }
                            player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.injection.in_use"), true);
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.injection.not_use"), true);
                        }
                        return false;
                    }).ifPresent(f -> {
                        stack.shrink(1);
                        if (stack.isEmpty()) {
                            player.getInventory().removeItem(stack);
                        }
                    });
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void useItem(PlayerInteractEvent.RightClickItem event) {
        Equipable equip;
        Item item;
        if (Helper.isWerewolf(event.getEntity()) && (item = event.getItemStack().getItem()) instanceof Equipable && (equip = (Equipable)item).getEquipmentSlot().isArmor()) {
            WerewolfPlayer.getOpt(event.getEntity()).ifPresent(s -> {
                if (!s.canWearArmor(event.getItemStack())) {
                    event.setCancellationResult(InteractionResult.FAIL);
                    event.setCanceled(true);
                    event.getEntity().displayClientMessage((Component)Component.translatable((String)"text.werewolves.equipment.equip_failed"), true);
                }
            });
        }
    }

    @SubscribeEvent
    public void playerSize(EntityEvent.Size event) {
        LazyOptional<WerewolfPlayer> werewolf;
        Optional size;
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getInventory() != null && event.getEntity().isAlive() && (size = (werewolf = WerewolfPlayer.getOpt((Player)event.getEntity())).map(WerewolfPlayer::getForm).flatMap(form -> form.getSize(event.getPose()))).isPresent()) {
            event.setNewSize((EntityDimensions)size.get());
            event.setNewEyeHeight(((EntityDimensions)size.get()).height * 0.85f);
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        int sum;
        LivingEntity source;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isWerewolf(player = (Player)livingEntity)) {
            WerewolfPlayer.getOpt(player).filter(w -> w.getForm() == WerewolfForm.SURVIVALIST).map(WerewolfPlayer::getSkillHandler).ifPresent(skillHandler -> {
                if (player.getDeltaMovement().lengthSqr() > 0.01 && skillHandler.isSkillEnabled((ISkill)ModSkills.ARROW_AWARENESS.get()) && event.getSource().is(DamageTypes.ARROW) && (double)event.getEntity().getRandom().nextFloat() < 0.4) {
                    event.setCanceled(true);
                } else if (player.isSprinting() && event.getSource().getEntity() != null && skillHandler.isSkillEnabled((ISkill)ModSkills.MOVEMENT_TACTICS.get())) {
                    float limit = ((Double)WerewolvesConfig.BALANCE.SKILLS.movement_tactics_doge_chance.get()).floatValue();
                    if (skillHandler.isRefinementEquipped((IRefinement)ModRefinements.GREATER_DOGE_CHANCE.get())) {
                        limit += ((Double)WerewolvesConfig.BALANCE.REFINEMENTS.greater_doge_chance.get()).floatValue();
                    }
                    if (player.getRandom().nextFloat() < limit) {
                        event.setCanceled(true);
                    }
                }
            });
            if (!event.isCanceled() && event.getSource().is(ModTags.DamageTypes.WEREWOLF_FUR_IMMUNE) && WerewolfPlayer.getOpt(player).filter(w -> w.getForm().isTransformed()).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())).orElse(false).booleanValue()) {
                event.setCanceled(true);
            }
        }
        if (event.getSource().is(DamageTypes.MOB_ATTACK) && (livingEntity = event.getSource().getDirectEntity()) instanceof LivingEntity && Helper.isWerewolf((Entity)(source = livingEntity)) && (sum = StreamSupport.stream(event.getEntity().getArmorSlots().spliterator(), false).mapToInt(stack -> stack.getItem() instanceof ISilverItem ? 1 : 0).sum()) > 0) {
            source.addEffect(SilverEffect.createSilverEffect(source, (Integer)WerewolvesConfig.BALANCE.UTIL.silverArmorAttackEffectDuration.get() * sum, 0));
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        MobEffectInstance effect;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isWerewolf(player = (Player)livingEntity) && (effect = player.getEffect((MobEffect)ModEffects.SILVER.get())) != null) {
            event.setAmount(event.getAmount() * (1.0f + (float)(effect.getAmplifier() + 1) * 0.1f));
        }
    }

    @SubscribeEvent
    public void onMountEvent(EntityMountEvent event) {
        if (event.isMounting() && WerewolfPlayer.getOptEx(event.getEntityMounting()).map(p -> !p.getForm().isHumanLike()).orElse(false).booleanValue()) {
            event.setCanceled(true);
            ((Player)event.getEntityMounting()).displayClientMessage((Component)Component.translatable((String)"text.werewolves.nomount.transformed"), true);
        }
    }

    @SubscribeEvent
    public void onSleepTime(SleepingTimeCheckEvent event) {
    }

    @SubscribeEvent
    public void isCorrectToolForDrop(PlayerEvent.HarvestCheck event) {
        if (!event.canHarvest() && Helper.isWerewolf(event.getEntity())) {
            WerewolfPlayer.getOpt(event.getEntity()).filter(a -> a.getForm().isTransformed()).ifPresent(werewolf -> event.setCanHarvest(event.getEntity().getMainHandItem().isEmpty() && werewolf.getDigDropTier().map(tier -> TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)event.getTargetBlock())).orElse(false) != false && (event.getTargetBlock().is(BlockTags.MINEABLE_WITH_PICKAXE) || event.getTargetBlock().is(BlockTags.MINEABLE_WITH_SHOVEL) || event.getTargetBlock().is(BlockTags.MINEABLE_WITH_HOE))));
        }
    }

    @SubscribeEvent
    public void tickTool(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Helper.isWerewolf(event.player)) {
            if (Helper.isSilverItem(event.player.getMainHandItem()) || Helper.isSilverItem(event.player.getOffhandItem()) && event.player.level().getGameTime() % 10L == 0L) {
                event.player.addEffect(SilverEffect.createSilverEffect((LivingEntity)event.player, 20, 1, true));
            }
            if (StreamSupport.stream(event.player.getArmorSlots().spliterator(), false).anyMatch(Helper::isSilverItem)) {
                event.player.addEffect(SilverEffect.createSilverEffect((LivingEntity)event.player, 20, 1, true));
            }
        }
    }
}

