/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.goals;

import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.werewolves.api.entities.IEntityFollower;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowAlphaWerewolfGoal<T extends WerewolfBaseEntity>
extends Goal {
    protected final T entity;
    protected final double speed;
    private final int DIST = 122;
    private int delayCounter;

    public FollowAlphaWerewolfGoal(T entity, double speed) {
        this.entity = entity;
        this.speed = speed;
    }

    public boolean canContinueToUse() {
        return ((IEntityFollower)this.entity).getLeader().map(leader -> {
            double d0 = this.entity.distanceToSqr((Entity)leader.getRepresentingEntity());
            return d0 >= 122.0 && d0 <= 256.0;
        }).orElse(false);
    }

    public boolean canUse() {
        if (((IEntityFollower)this.entity).getLeader().isEmpty()) {
            List list = this.entity.getCommandSenderWorld().getEntitiesOfClass(WerewolfBaseEntity.class, this.entity.getBoundingBox().inflate(16.0, 8.0, 16.0), entity -> entity instanceof IEntityLeader);
            double d0 = Double.MAX_VALUE;
            IEntityLeader newLeader = null;
            for (WerewolfBaseEntity entity2 : list) {
                double d1;
                IEntityLeader leader2 = (IEntityLeader)entity2;
                if (!entity2.isAlive() || leader2.getFollowingCount() >= leader2.getMaxFollowerCount() || !((d1 = this.entity.distanceToSqr((Entity)entity2)) <= d0)) continue;
                d0 = d1;
                newLeader = leader2;
            }
            if (newLeader != null) {
                ((IEntityFollower)this.entity).setLeader(newLeader);
                newLeader.increaseFollowerCount();
            }
        }
        return ((IEntityFollower)this.entity).getLeader().map(leader -> leader.getRepresentingEntity().isAlive() && this.entity.distanceToSqr((Entity)leader.getRepresentingEntity()) > 122.0).orElse(false);
    }

    public void start() {
        this.delayCounter = 0;
    }

    public void tick() {
        if (--this.delayCounter <= 0 && ((IEntityFollower)this.entity).getLeader().isPresent()) {
            this.delayCounter = 10;
            ((IEntityFollower)this.entity).getLeader().ifPresent(leader -> {
                this.entity.getNavigation().moveTo((Entity)leader.getRepresentingEntity(), this.speed);
                this.entity.lookAt(EntityAnchorArgument.Anchor.EYES, leader.getRepresentingEntity().position().add(0.0, (double)leader.getRepresentingEntity().getEyeHeight(), 0.0));
            });
        }
    }
}

